/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.ignivorus;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import com.leon.saintsdragons.server.entity.dragons.util.DragonDestructionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class IgnivorusFireBreathAbility
extends DragonAbility<Ignivorus> {
    private static final int STARTUP_TICKS = 4;
    private static final int RIDER_ACTIVE_TICKS = 400;
    private static final int AI_ACTIVE_TICKS = 80;
    private static final int COOLDOWN_TICKS = 40;
    private static final double MAX_RANGE = 64.0;
    private static final double IMPACT_RADIUS = 1.25;
    private static final float DEFAULT_DAMAGE_PER_SECOND = 80.0f;
    private static final int FIRE_DURATION_SECONDS = 3;
    private static final int ABILITY_ACTIVE_BEFORE_MELTING = 80;
    private static final int BLOCK_MELT_TICKS = 40;
    private static final DragonAbilitySection[] RIDER_TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 4), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 400)};
    private static final DragonAbilitySection[] AI_TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 4), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 80)};
    private boolean breathStartPlayed = false;
    private boolean breathLoopActive = false;
    private int totalActiveTicks = 0;

    public IgnivorusFireBreathAbility(DragonAbilityType<Ignivorus, IgnivorusFireBreathAbility> type, Ignivorus user) {
        super(type, user, user.m_6688_() != null ? RIDER_TRACK : AI_TRACK, 40);
    }

    @Override
    protected void beginSection(@Nullable DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        Ignivorus dragon = (Ignivorus)this.getUser();
        if (!dragon.m_21824_() && dragon.m_6688_() == null && !this.isValidTarget(dragon.m_5448_())) {
            this.interrupt();
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.breathStartPlayed = true;
            this.breathLoopActive = false;
            this.totalActiveTicks = 0;
            dragon.setBreathingFire(false);
            dragon.setFireBreathProgress(0);
            dragon.clearFireBreathPath();
            dragon.triggerAnim("action", "fire_breath_start");
            if (!dragon.m_9236_().f_46443_) {
                float pitch = 0.92f + dragon.m_217043_().m_188501_() * 0.15f;
                dragon.m_5496_(ModSounds.IGNIVORUS_FIRE_BREATH_START.get(), 2.0f, pitch);
            }
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            dragon.setBreathingFire(true);
            dragon.triggerAnim("action", "fire_breathing");
            this.breathLoopActive = true;
        }
    }

    @Override
    protected void endSection(@Nullable DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            Ignivorus dragon = (Ignivorus)this.getUser();
            dragon.setBreathingFire(false);
            dragon.clearFireBreathPath();
            this.triggerBreathStop(dragon);
        }
    }

    @Override
    public void interrupt() {
        Ignivorus dragon = (Ignivorus)this.getUser();
        dragon.setBreathingFire(false);
        dragon.setFireBreathProgress(0);
        dragon.clearFireBreathPath();
        this.totalActiveTicks = 0;
        this.triggerBreathStop(dragon);
        super.interrupt();
    }

    private void triggerBreathStop(Ignivorus dragon) {
        if (this.breathLoopActive || this.breathStartPlayed) {
            dragon.triggerAnim("action", "fire_breath_stop");
            if (!dragon.m_9236_().f_46443_) {
                float pitch = 0.92f + dragon.m_217043_().m_188501_() * 0.15f;
                dragon.m_5496_(ModSounds.IGNIVORUS_FIRE_BREATH_END.get(), 2.0f, pitch);
            }
        }
        this.breathStartPlayed = false;
        this.breathLoopActive = false;
    }

    @Override
    protected boolean canContinueUsing() {
        Ignivorus dragon = (Ignivorus)this.getUser();
        if (!dragon.m_6084_() || dragon.m_213877_()) {
            return false;
        }
        return !dragon.m_20072_();
    }

    @Override
    public void tickUsing() {
        Level level;
        Vec3 origin;
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null || section.sectionType != DragonAbilitySection.AbilitySectionType.ACTIVE) {
            return;
        }
        Ignivorus dragon = (Ignivorus)this.getUser();
        if (!dragon.m_21824_() && dragon.m_6688_() == null && !this.isValidTarget(dragon.m_5448_())) {
            this.interrupt();
            return;
        }
        ++this.totalActiveTicks;
        int currentProgress = dragon.getFireBreathProgress();
        if (currentProgress < 40) {
            dragon.setFireBreathProgress(currentProgress + 1);
        }
        if ((origin = dragon.getFireBreathStartAnchor(1.0f)) == null) {
            dragon.clearFireBreathPath();
            return;
        }
        Vec3 aim = dragon.refreshFireAimDirection(origin, false);
        if (aim == null || aim.m_82556_() < 1.0E-6) {
            dragon.clearFireBreathPath();
            return;
        }
        Vec3 impact = this.traceImpact(dragon, origin, aim);
        dragon.syncFireBreathPath(origin, impact);
        if (currentProgress > 10 && (level = dragon.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double sizeScale = Math.max(0.8, (double)dragon.m_20205_());
            float damage = IgnivorusFireBreathAbility.computeDamage(dragon, sizeScale);
            double radius = 1.25 * sizeScale;
            double progressRatio = Math.min(1.0, (double)currentProgress / 40.0);
            Vec3 currentImpact = origin.m_82549_(impact.m_82546_(origin).m_82490_(progressRatio));
            boolean canMeltBlocks = this.totalActiveTicks >= 80;
            DragonDestructionManager.applyFireBreathImpact(serverLevel, dragon, currentImpact, radius, damage, 3, 40, canMeltBlocks);
        }
    }

    private static float computeDamage(Ignivorus dragon, double sizeScale) {
        float configDamagePerSecond = (float)DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.IGNIVORUS_ID).abilityDamage("fire_breath", 80.0);
        return configDamagePerSecond / 20.0f;
    }

    private Vec3 traceImpact(Ignivorus dragon, Vec3 origin, Vec3 direction) {
        Vec3 reach = origin.m_82549_(direction.m_82490_(64.0));
        ClipContext ctx = new ClipContext(origin, reach, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)dragon);
        BlockHitResult hit = dragon.m_9236_().m_45547_(ctx);
        if (hit == null || hit.m_6662_() == HitResult.Type.MISS) {
            return reach;
        }
        return hit.m_82450_();
    }

    private boolean isValidTarget(LivingEntity target) {
        Player player;
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (target.m_213877_()) {
            return false;
        }
        return !(target instanceof Player) || !(player = (Player)target).m_7500_() && !player.m_5833_();
    }
}

