/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.ignivorus;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class IgnivorusBodySlamAbility
extends DragonAbility<Ignivorus> {
    private static final int STARTUP_TICKS = 15;
    private static final int ACTIVE_TICKS = 6;
    private static final int RECOVERY_TICKS = 8;
    private static final int CONTROL_LOCK_TICKS = 29;
    private static final int COOLDOWN_TICKS = 30;
    private static final float BASE_DAMAGE = 40.0f;
    private static final double PUSH_STRENGTH = 1.1;
    private static final double LIFT_FORCE = 0.6;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 15), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 8)};
    private boolean impactApplied;

    public IgnivorusBodySlamAbility(DragonAbilityType<Ignivorus, IgnivorusBodySlamAbility> type, Ignivorus user) {
        super(type, user, TRACK, 30);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        Ignivorus dragon = (Ignivorus)this.getUser();
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.impactApplied = false;
            dragon.triggerAnim("action", "body_slam");
            dragon.lockRiderControls(29);
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        Ignivorus dragon = (Ignivorus)this.getUser();
        if (dragon == null) {
            return;
        }
        if (dragon.m_29443_()) {
            this.interrupt();
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.impactApplied) {
            this.impactApplied = true;
            this.applySlam(dragon);
        }
    }

    private void applySlam(Ignivorus dragon) {
        Level level = dragon.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double inflateXZ = Math.max(1.5, (double)dragon.m_20205_()) * 1.75;
        double inflateY = Math.max(1.5, (double)dragon.m_20206_() * 1.75);
        AABB slamArea = dragon.m_20191_().m_82377_(inflateXZ, inflateY, inflateXZ);
        List targets = server.m_6443_(LivingEntity.class, slamArea, entity -> entity != dragon && entity.m_6084_() && entity.m_5789_() && !dragon.isAlly((Entity)entity));
        if (targets.isEmpty()) {
            return;
        }
        float damage = IgnivorusBodySlamAbility.computeDamage(dragon);
        DamageSource source = server.m_269111_().m_269333_((LivingEntity)dragon);
        for (LivingEntity target : targets) {
            target.m_6469_(source, damage);
            Vec3 push = target.m_20182_().m_82546_(dragon.m_20182_());
            if (push.m_82556_() < 1.0E-4) {
                push = new Vec3(0.0, 0.0, 1.0);
            }
            push = push.m_82541_();
            double scaledPush = 1.1 + (double)dragon.m_20205_() * 0.15;
            target.m_5997_(push.f_82479_ * scaledPush, 0.6, push.f_82481_ * scaledPush);
            target.f_19812_ = true;
        }
    }

    private static float computeDamage(Ignivorus dragon) {
        double attack = dragon.m_21133_(Attributes.f_22281_);
        return IgnivorusBodySlamAbility.resolveBaseDamage() + (float)(attack * 0.75);
    }

    private static float resolveBaseDamage() {
        return (float)DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.IGNIVORUS_ID).abilityDamage("body_slam", 40.0);
    }

    @Override
    public boolean tryAbility() {
        Ignivorus dragon = (Ignivorus)this.getUser();
        if (dragon == null || dragon.m_6162_() || dragon.m_29443_() || !dragon.m_20096_() || dragon.areRiderControlsLocked()) {
            return false;
        }
        return super.tryAbility();
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section != null && section.sectionType == DragonAbilitySection.AbilitySectionType.RECOVERY) {
            this.impactApplied = false;
        }
    }

    @Override
    public void interrupt() {
        this.impactApplied = false;
        super.interrupt();
    }
}

