/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.ignivorus;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class IgnivorusBiteAbility
extends DragonAbility<Ignivorus> {
    private static final float BASE_DAMAGE = 50.0f;
    private static final float ARMOR_PENETRATION = 5.0f;
    private static final double BASE_AOE_RADIUS = 5.0;
    private static final double RIDDEN_RADIUS_BONUS = 2.0;
    private static final double AIR_RADIUS_BONUS = 1.0;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 3), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 8)};
    private boolean appliedHit;

    public IgnivorusBiteAbility(DragonAbilityType<Ignivorus, IgnivorusBiteAbility> type, Ignivorus user) {
        super(type, user, TRACK, 20);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Ignivorus dragon = (Ignivorus)this.getUser();
            dragon.triggerAnim("action", "bite");
            this.appliedHit = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.appliedHit) {
            LivingEntity currentTarget;
            Ignivorus dragon = (Ignivorus)this.getUser();
            List<LivingEntity> targets = this.selectTargets();
            if (targets.isEmpty() && (currentTarget = dragon.m_5448_()) != null && currentTarget.m_6084_() && !dragon.isAlly((Entity)currentTarget)) {
                targets = List.of(currentTarget);
            }
            for (LivingEntity target : targets) {
                this.applyHit(dragon, target);
            }
            this.appliedHit = true;
        }
    }

    private void applyHit(Ignivorus dragon, LivingEntity target) {
        double value;
        float damage = this.resolveBiteDamage();
        AttributeInstance attackAttr = dragon.m_21051_(Attributes.f_22281_);
        if (attackAttr != null && (value = attackAttr.m_22135_()) > 0.0) {
            damage = Math.max(50.0f, (float)value);
        }
        DamageSource physicalSource = dragon.m_9236_().m_269111_().m_269333_((LivingEntity)dragon);
        float armorPenDamage = damage + 5.0f;
        target.m_6469_(physicalSource, armorPenDamage);
        target.m_20254_(3);
        Vec3 push = dragon.m_20154_().m_82490_(dragon.m_29443_() ? 0.4 : 0.25);
        target.m_5997_(push.f_82479_, dragon.m_29443_() ? 0.2 : 0.08, push.f_82481_);
    }

    private float resolveBiteDamage() {
        return (float)DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.IGNIVORUS_ID).abilityDamage("bite", 50.0);
    }

    private List<LivingEntity> selectTargets() {
        Ignivorus dragon = (Ignivorus)this.getUser();
        double radius = 5.0;
        if (dragon.m_6688_() != null) {
            radius += 2.0;
        }
        if (dragon.m_29443_()) {
            radius += 1.0;
        }
        Vec3 mouthPos = dragon.getMouthPosition();
        AABB detectionBox = new AABB(mouthPos, mouthPos).m_82400_(radius);
        double finalRadius = radius;
        double finalRadius1 = radius;
        List candidates = dragon.m_9236_().m_6443_(LivingEntity.class, detectionBox, entity -> {
            if (entity == dragon || !entity.m_6084_() || !entity.m_5789_() || dragon.isAlly((Entity)entity)) {
                return false;
            }
            Vec3 entityCenter = entity.m_20191_().m_82399_();
            double distSqr = entityCenter.m_82557_(mouthPos);
            return distSqr <= finalRadius * finalRadius1;
        });
        candidates.sort(Comparator.comparingDouble(e -> e.m_20191_().m_82399_().m_82557_(mouthPos)));
        return candidates;
    }
}

