/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.cindervane;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import com.leon.saintsdragons.server.entity.effect.cindervane.CindervaneMagmaBlockEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CindervaneVolleyAbility
extends DragonAbility<Cindervane> {
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 3), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 20), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 5)};
    private static final int MAX_VOLLEYS = 3;
    private static final int BLOCKS_PER_VOLLEY = 3;
    private static final int VOLLEY_INTERVAL_TICKS = 10;
    private static final int COOLDOWN_TICKS = 5;
    private static final int MAGMA_BLOCK_LIFETIME = 200;
    private static final double SPAWN_FORWARD_OFFSET = 5.0;
    private static final double SPAWN_VERTICAL_OFFSET = 1.5;
    private static final double VELOCITY_DOWN = -0.15;
    private static final double VELOCITY_FORWARD = 0.55;
    private static final double MAGMA_IMPACT_RADIUS = 7.0;
    private static final float DEFAULT_IMPACT_DAMAGE = 20.0f;
    private int ticksSinceVolley;
    private int volleysFired;

    public CindervaneVolleyAbility(DragonAbilityType<Cindervane, CindervaneVolleyAbility> type, Cindervane user) {
        super(type, user, TRACK, 5);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.ticksSinceVolley = 10;
            this.volleysFired = 0;
            ((Cindervane)this.getUser()).triggerAnim("actions", "magma_blast");
            Level level = this.getLevel();
            level.m_5594_(null, ((Cindervane)this.getUser()).m_20183_(), SoundEvents.f_11705_, ((Cindervane)this.getUser()).m_5720_(), 1.4f, 0.8f + ((Cindervane)this.getUser()).m_217043_().m_188501_() * 0.2f);
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null || section.sectionType != DragonAbilitySection.AbilitySectionType.ACTIVE) {
            return;
        }
        ++this.ticksSinceVolley;
        if (this.ticksSinceVolley >= 10 && this.volleysFired < 3) {
            this.ticksSinceVolley = 0;
            this.fireVolley();
            ++this.volleysFired;
        }
        if (this.volleysFired >= 3 && this.ticksSinceVolley >= 10) {
            this.nextSection();
        }
    }

    private void fireVolley() {
        Cindervane dragon = (Cindervane)this.getUser();
        Level level = dragon.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Vec3 mouth = dragon.computeMouthOrigin(1.0f).m_82520_(0.0, 1.5, 0.0);
        float baseYaw = dragon.f_20885_;
        float basePitch = dragon.m_146909_();
        for (int i = 0; i < 3; ++i) {
            float yawOffset = (float)(i - 1) * 9.5f + (dragon.m_217043_().m_188501_() - 0.5f) * 6.0f;
            float pitchOffset = (dragon.m_217043_().m_188501_() - 0.5f) * 4.0f;
            float yaw = baseYaw + yawOffset;
            float pitch = basePitch + pitchOffset;
            Vec3 direction = Vec3.m_82498_((float)pitch, (float)yaw).m_82541_();
            Vec3 spawnPos = mouth.m_82549_(direction.m_82490_(5.0));
            CindervaneMagmaBlockEntity block = new CindervaneMagmaBlockEntity((Level)server, spawnPos, dragon, 7.0, this.resolveImpactDamage(), 200);
            block.m_20256_(direction.m_82490_(0.55).m_82520_(0.0, -0.15, 0.0));
            server.m_7967_((Entity)block);
        }
    }

    private float resolveImpactDamage() {
        return (float)DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.CINDERVANE_ID).abilityDamage("magma_volley", 20.0);
    }
}

