/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.cindervane;

import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfigLoader;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CindervaneBiteAbility
extends DragonAbility<Cindervane> {
    private static final float BASE_DAMAGE = 12.0f;
    private static final double BASE_RANGE = 10.0;
    private static final double RIDDEN_RANGE_BONUS = 10.0;
    private static final double AIR_RANGE_BONUS = 0.6;
    private static final double HIT_ANGLE_COS = Math.cos(Math.toRadians(75.0));
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 5), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 2), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 5)};
    private boolean appliedHit;

    public CindervaneBiteAbility(DragonAbilityType<Cindervane, CindervaneBiteAbility> type, Cindervane user) {
        super(type, user, TRACK, 15);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Cindervane dragon = (Cindervane)this.getUser();
            dragon.triggerAnim("actions", "bite");
            this.appliedHit = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.appliedHit) {
            LivingEntity currentTarget;
            Cindervane dragon = (Cindervane)this.getUser();
            List<LivingEntity> targets = this.selectTargets();
            if (targets.isEmpty() && (currentTarget = dragon.m_5448_()) != null && currentTarget.m_6084_() && !dragon.isAlly((Entity)currentTarget)) {
                targets = List.of(currentTarget);
            }
            for (LivingEntity target : targets) {
                this.applyHit(dragon, target);
            }
            this.appliedHit = true;
        }
    }

    private void applyHit(Cindervane dragon, LivingEntity target) {
        double value;
        float damage = (float)DragonAttributeConfigLoader.getInstance().getConfig(DragonAttributeConfigLoader.CINDERVANE_ID).abilityDamage("bite", 12.0);
        AttributeInstance attackAttr = dragon.m_21051_(Attributes.f_22281_);
        if (attackAttr != null && (value = attackAttr.m_22135_()) > 0.0) {
            damage = (float)value;
        }
        DamageSource source = dragon.m_9236_().m_269111_().m_269333_((LivingEntity)dragon);
        target.m_6469_(source, damage);
        Vec3 push = dragon.m_20154_().m_82490_(0.3);
        target.m_5997_(push.f_82479_, dragon.m_29443_() ? 0.15 : 0.05, push.f_82481_);
    }

    private List<LivingEntity> selectTargets() {
        Cindervane dragon = (Cindervane)this.getUser();
        double range = 10.0;
        if (dragon.m_6688_() != null) {
            range += 10.0;
        }
        if (dragon.m_29443_()) {
            range += 0.6;
        }
        Vec3 origin = dragon.getMouthPosition();
        Vec3 look = dragon.m_20154_().m_82541_();
        Vec3 end = origin.m_82549_(look.m_82490_(range));
        AABB sweep = new AABB(origin, end).m_82377_(1.2, 1.0, 1.2);
        List candidates = dragon.m_9236_().m_6443_(LivingEntity.class, sweep, entity -> entity != dragon && entity.m_6084_() && entity.m_5789_() && !dragon.isAlly((Entity)entity));
        double effectiveRange = range;
        ArrayList<LivingEntity> results = new ArrayList<LivingEntity>();
        candidates.stream().map(entity -> {
            double closeEnough;
            Vec3 center = entity.m_20191_().m_82399_();
            Vec3 toward = center.m_82546_(origin);
            double distanceSqr = toward.m_82556_();
            if (distanceSqr < 1.0E-6) {
                return new TargetScore((LivingEntity)entity, 1.0, 0.0);
            }
            Vec3 dir = toward.m_82541_();
            double dot = dir.m_82526_(look);
            if (dot < HIT_ANGLE_COS && (closeEnough = center.m_82557_(origin)) > effectiveRange * effectiveRange * 0.64) {
                return null;
            }
            return new TargetScore((LivingEntity)entity, dot, distanceSqr);
        }).filter(Objects::nonNull).sorted(Comparator.comparingDouble(TargetScore::dot).reversed().thenComparingDouble(TargetScore::distanceSqr)).map(TargetScore::entity).forEach(entity -> {
            if (!results.contains(entity)) {
                results.add((LivingEntity)entity);
            }
        });
        return results;
    }

    private record TargetScore(LivingEntity entity, double dot, double distanceSqr) {
    }
}

