/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import net.minecraft.world.entity.LivingEntity;

public record DragonAbilityType<M extends LivingEntity, T extends DragonAbility<M>>(String name, IFactory<M, T> factory) implements Comparable<DragonAbilityType<M, T>>
{
    public DragonAbilityType {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Ability name must not be null/empty");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null for ability: " + name);
        }
    }

    public T makeInstance(M user) {
        return this.factory.create(this, user);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(DragonAbilityType<M, T> o) {
        return this.getName().compareTo(o.getName());
    }

    public static interface IFactory<M extends LivingEntity, T extends DragonAbility<M>> {
        public T create(DragonAbilityType<M, T> var1, M var2);
    }
}

