/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import net.minecraft.sounds.SoundEvent;

public class DieAbility<T extends DragonEntity>
extends DragonAbility<T> {
    public DieAbility(DragonAbilityType<T, ? extends DragonAbility<T>> type, T user) {
        super(type, user, DieAbility.buildTrack(user), 0);
    }

    private static <E extends DragonEntity> DragonAbilitySection[] buildTrack(E dragon) {
        int duration = Math.max(1, dragon.getDeathAnimationDurationTicks());
        return new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, duration)};
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        DragonEntity dragon = (DragonEntity)((Object)this.getUser());
        dragon.onDeathAbilityStarted();
        String abilityId = this.getAbilityType().getName();
        String controllerId = "action";
        DragonEntity.VocalEntry deathEntry = dragon.getVocalEntries().get(abilityId);
        if (deathEntry != null && deathEntry.controllerId() != null) {
            controllerId = deathEntry.controllerId();
        }
        String animationTrigger = "die";
        if (abilityId.startsWith("baby_")) {
            animationTrigger = "baby_die";
        } else if ("nulljaw_die".equals(abilityId)) {
            animationTrigger = "nulljaw_die";
        }
        dragon.triggerAnim(controllerId, animationTrigger);
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        if (this.getTicksInSection() == 1 && !this.getLevel().f_46443_) {
            DragonEntity dragon = (DragonEntity)((Object)this.getUser());
            String abilityId = this.getAbilityType().getName();
            DragonEntity.VocalEntry deathEntry = dragon.getVocalEntries().get(abilityId);
            if (deathEntry != null && deathEntry.soundSupplier() != null) {
                SoundEvent sound = deathEntry.soundSupplier().get();
                float volume = deathEntry.volume();
                float pitch = deathEntry.basePitch() + (dragon.m_217043_().m_188501_() - 0.5f) * deathEntry.pitchVariance() * 2.0f;
                dragon.m_5496_(sound, volume, pitch);
            }
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        this.complete();
    }

    @Override
    public boolean damageInterrupts() {
        return false;
    }
}

