/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.command;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.LinkedHashSet;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public final class DragonTameCommand {
    private static final double SUGGESTION_RADIUS = 64.0;
    private static final double HIT_RANGE = 64.0;
    private static final SuggestionProvider<CommandSourceStack> DRAGON_UUID_SUGGESTIONS = (context, builder) -> {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        LinkedHashSet<DragonEntity> ordered = new LinkedHashSet<DragonEntity>();
        DragonEntity lookedAt = DragonTameCommand.findLookedAtDragon(source);
        if (lookedAt != null) {
            ordered.add(lookedAt);
        }
        for (DragonEntity dragon : ordered) {
            builder.suggest(dragon.m_20148_().toString(), (Message)dragon.m_5446_());
        }
        return builder.buildFuture();
    };
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_DRAGON = new DynamicCommandExceptionType(id -> Component.m_237110_((String)"saintsdragons.command.tame.not_found", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType ERROR_ALREADY_TAMED = new DynamicCommandExceptionType(name -> Component.m_237110_((String)"saintsdragons.command.tame.already", (Object[])new Object[]{name}));
    private static final DynamicCommandExceptionType ERROR_OWNERSHIP_CONFLICT = new DynamicCommandExceptionType(args -> Component.m_237110_((String)"saintsdragons.command.tame.ownership_conflict", (Object[])new Object[]{((Object[])args)[0], ((Object[])args)[1]}));

    private DragonTameCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tame").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dragon", DragonTameCommand.uuidArgument()).suggests(DRAGON_UUID_SUGGESTIONS).executes(ctx -> DragonTameCommand.tameDragon((CommandContext<CommandSourceStack>)ctx, (Player)((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> DragonTameCommand.tameDragon((CommandContext<CommandSourceStack>)ctx, (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player"))))));
    }

    private static ArgumentType<UUID> uuidArgument() {
        return UuidArgument.m_113850_();
    }

    private static int tameDragon(CommandContext<CommandSourceStack> context, Player owner) throws CommandSyntaxException {
        UUID dragonId = UuidArgument.m_113853_(context, (String)"dragon");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        DragonEntity dragon = DragonTameCommand.findDragon(source, dragonId);
        if (dragon == null) {
            throw ERROR_UNKNOWN_DRAGON.create((Object)dragonId.toString());
        }
        if (dragon.m_21824_() && dragon.m_269323_() != null) {
            if (dragon.m_21830_((LivingEntity)owner)) {
                throw ERROR_ALREADY_TAMED.create((Object)dragon.m_5446_().getString());
            }
            Player currentOwner = (Player)dragon.m_269323_();
            throw ERROR_OWNERSHIP_CONFLICT.create((Object)new Object[]{dragon.m_5446_().getString(), currentOwner.m_5446_().getString()});
        }
        dragon.m_21828_(owner);
        dragon.m_21839_(false);
        dragon.m_6710_(null);
        if (owner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            DragonTameCommand.triggerTamingAdvancement(serverPlayer, dragon);
        }
        MutableComponent successMessage = Component.m_237110_((String)"saintsdragons.command.tame.success", (Object[])new Object[]{dragon.m_5446_(), owner.m_5446_()});
        source.m_288197_(() -> DragonTameCommand.lambda$tameDragon$7((Component)successMessage), false);
        return 1;
    }

    private static void triggerTamingAdvancement(ServerPlayer player, DragonEntity dragon) {
        Advancement femaleAdvancement;
        String dragonType = DragonTameCommand.getDragonTypeName(dragon);
        if (dragonType == null) {
            return;
        }
        if (dragon.isFemale() && (femaleAdvancement = player.f_8924_.m_129889_().m_136041_(SaintsDragonsCommon.rl("tame_" + dragonType + "_female"))) != null) {
            player.m_8960_().m_135988_(femaleAdvancement, "tame_" + dragonType + "_female");
            return;
        }
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(SaintsDragonsCommon.rl("tame_" + dragonType));
        if (advancement != null) {
            player.m_8960_().m_135988_(advancement, "tame_" + dragonType);
        }
    }

    private static String getDragonTypeName(DragonEntity dragon) {
        String className = ((Object)((Object)dragon)).getClass().getSimpleName().toLowerCase();
        return className;
    }

    private static DragonEntity findDragon(CommandSourceStack source, UUID id) {
        Entity entity = source.m_81372_().m_8791_(id);
        if (entity instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)entity;
            return dragon;
        }
        return null;
    }

    private static DragonEntity findLookedAtDragon(CommandSourceStack source) {
        Entity entity;
        Entity sourceEntity = source.m_81373_();
        if (!(sourceEntity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity living = (LivingEntity)sourceEntity;
        Vec3 start = living.m_146892_();
        Vec3 look = living.m_20252_(1.0f);
        Vec3 end = start.m_82549_(look.m_82490_(64.0));
        AABB box = living.m_20191_().m_82369_(look.m_82490_(64.0)).m_82400_(1.0);
        EntityHitResult result = ProjectileUtil.m_37304_((Level)living.m_9236_(), (Entity)living, (Vec3)start, (Vec3)end, (AABB)box, target -> target instanceof DragonEntity && target.m_6087_());
        if (result != null && (entity = result.m_82443_()) instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)entity;
            return dragon;
        }
        return null;
    }

    private static /* synthetic */ Component lambda$tameDragon$7(Component successMessage) {
        return successMessage;
    }
}

