/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.command;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.base.DragonGender;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.LinkedHashSet;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public final class DragonSetGenderCommand {
    private static final double HIT_RANGE = 64.0;
    private static final SuggestionProvider<CommandSourceStack> DRAGON_UUID_SUGGESTIONS = (context, builder) -> {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        LinkedHashSet<DragonEntity> ordered = new LinkedHashSet<DragonEntity>();
        DragonEntity lookedAt = DragonSetGenderCommand.findLookedAtDragon(source);
        if (lookedAt != null) {
            ordered.add(lookedAt);
        }
        for (DragonEntity dragon : ordered) {
            builder.suggest(dragon.m_20148_().toString(), (Message)dragon.m_5446_());
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> GENDER_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"male", "female"}, (SuggestionsBuilder)builder);
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_DRAGON = new DynamicCommandExceptionType(id -> Component.m_237110_((String)"saintsdragons.command.setgender.not_found", (Object[])new Object[]{id}));
    private static final SimpleCommandExceptionType ERROR_INVALID_GENDER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"saintsdragons.command.setgender.invalid_gender"));

    private DragonSetGenderCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setgender").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"dragon", DragonSetGenderCommand.uuidArgument()).suggests(DRAGON_UUID_SUGGESTIONS).then(Commands.m_82129_((String)"gender", (ArgumentType)StringArgumentType.word()).suggests(GENDER_SUGGESTIONS).executes(DragonSetGenderCommand::setGender))));
    }

    private static ArgumentType<UUID> uuidArgument() {
        return UuidArgument.m_113850_();
    }

    private static int setGender(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        UUID dragonId = UuidArgument.m_113853_(context, (String)"dragon");
        String genderStr = StringArgumentType.getString(context, (String)"gender").toLowerCase();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        DragonGender gender = switch (genderStr) {
            case "male" -> DragonGender.MALE;
            case "female" -> DragonGender.FEMALE;
            default -> throw ERROR_INVALID_GENDER.create();
        };
        DragonEntity dragon = DragonSetGenderCommand.findDragon(source, dragonId);
        if (dragon == null) {
            throw ERROR_UNKNOWN_DRAGON.create((Object)dragonId.toString());
        }
        DragonGender oldGender = dragon.getGender();
        dragon.setGender(gender);
        MutableComponent successMessage = Component.m_237110_((String)"saintsdragons.command.setgender.success", (Object[])new Object[]{dragon.m_5446_(), Component.m_237115_((String)("saintsdragons.gender." + genderStr))});
        source.m_288197_(() -> DragonSetGenderCommand.lambda$setGender$4((Component)successMessage), false);
        if (oldGender == gender) {
            MutableComponent infoMessage = Component.m_237110_((String)"saintsdragons.command.setgender.unchanged", (Object[])new Object[]{dragon.m_5446_()});
            source.m_288197_(() -> DragonSetGenderCommand.lambda$setGender$5((Component)infoMessage), false);
        }
        return 1;
    }

    private static DragonEntity findDragon(CommandSourceStack source, UUID id) {
        Entity entity = source.m_81372_().m_8791_(id);
        if (entity instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)entity;
            return dragon;
        }
        return null;
    }

    private static DragonEntity findLookedAtDragon(CommandSourceStack source) {
        Entity entity;
        Entity sourceEntity = source.m_81373_();
        if (!(sourceEntity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity living = (LivingEntity)sourceEntity;
        Vec3 start = living.m_146892_();
        Vec3 look = living.m_20252_(1.0f);
        Vec3 end = start.m_82549_(look.m_82490_(64.0));
        AABB box = living.m_20191_().m_82369_(look.m_82490_(64.0)).m_82400_(1.0);
        EntityHitResult result = ProjectileUtil.m_37304_((Level)living.m_9236_(), (Entity)living, (Vec3)start, (Vec3)end, (AABB)box, target -> target instanceof DragonEntity && target.m_6087_());
        if (result != null && (entity = result.m_82443_()) instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)entity;
            return dragon;
        }
        return null;
    }

    private static /* synthetic */ Component lambda$setGender$5(Component infoMessage) {
        return infoMessage;
    }

    private static /* synthetic */ Component lambda$setGender$4(Component successMessage) {
        return successMessage;
    }
}

