/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.command;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.handler.DragonAllyManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DragonAllyCommand {
    private static final SuggestionProvider<CommandSourceStack> DRAGON_SUGGESTIONS = (context, builder) -> {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        return SharedSuggestionProvider.m_82981_(source.m_81372_().m_45976_(DragonEntity.class, source.m_81373_() != null ? source.m_81373_().m_20191_().m_82400_(50.0) : AABB.m_165882_((Vec3)source.m_81371_(), (double)100.0, (double)100.0, (double)100.0)).stream().filter(dragon -> dragon.m_21824_() && source.m_81373_() instanceof Player && dragon.m_21830_((LivingEntity)((Player)source.m_81373_()))).map(dragon -> String.valueOf(dragon.m_19879_())), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dragonally").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"drake", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"username", (ArgumentType)StringArgumentType.string()).executes(DragonAllyCommand::addAlly))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"drake", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"username", (ArgumentType)StringArgumentType.string()).executes(DragonAllyCommand::removeAlly))))).then(Commands.m_82127_((String)"list").then(Commands.m_82129_((String)"drake", (ArgumentType)EntityArgument.m_91449_()).executes(DragonAllyCommand::listAllies)))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"drake", (ArgumentType)EntityArgument.m_91449_()).executes(DragonAllyCommand::clearAllies))));
    }

    private static int addAlly(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection entities = EntityArgument.m_91461_(context, (String)"drake");
        String username = StringArgumentType.getString(context, (String)"username");
        int successCount = 0;
        for (Entity entity : entities) {
            if (entity instanceof DragonEntity) {
                DragonEntity dragon = (DragonEntity)entity;
                DragonAllyManager.AllyResult result = dragon.allyManager.addAlly(username);
                MutableComponent message = Component.m_237110_((String)"saintsdragons.command.ally.add.result", (Object[])new Object[]{dragon.m_5446_(), username, result.getMessage()});
                source.m_288197_(() -> DragonAllyCommand.lambda$addAlly$4((Component)message), false);
                if (!result.isSuccess()) continue;
                ++successCount;
                continue;
            }
            source.m_81352_((Component)Component.m_237110_((String)"saintsdragons.command.ally.not_dragon", (Object[])new Object[]{entity.m_5446_()}));
        }
        return successCount;
    }

    private static int removeAlly(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection entities = EntityArgument.m_91461_(context, (String)"drake");
        String username = StringArgumentType.getString(context, (String)"username");
        int successCount = 0;
        for (Entity entity : entities) {
            if (entity instanceof DragonEntity) {
                DragonEntity dragon = (DragonEntity)entity;
                DragonAllyManager.AllyResult result = dragon.allyManager.removeAlly(username);
                MutableComponent message = Component.m_237110_((String)"saintsdragons.command.ally.remove.result", (Object[])new Object[]{dragon.m_5446_(), username, result.getMessage()});
                source.m_288197_(() -> DragonAllyCommand.lambda$removeAlly$5((Component)message), false);
                if (!result.isSuccess()) continue;
                ++successCount;
                continue;
            }
            source.m_81352_((Component)Component.m_237110_((String)"saintsdragons.command.ally.not_dragon", (Object[])new Object[]{entity.m_5446_()}));
        }
        return successCount;
    }

    private static int listAllies(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection entities = EntityArgument.m_91461_(context, (String)"drake");
        for (Entity entity : entities) {
            if (entity instanceof DragonEntity) {
                DragonEntity dragon = (DragonEntity)entity;
                List<String> allies = dragon.allyManager.getAllyUsernames();
                MutableComponent header = Component.m_237110_((String)"saintsdragons.command.ally.list.header", (Object[])new Object[]{dragon.m_5446_(), allies.size(), dragon.allyManager.getMaxAllies()});
                source.m_288197_(() -> DragonAllyCommand.lambda$listAllies$6((Component)header), false);
                if (allies.isEmpty()) {
                    source.m_288197_(() -> Component.m_237115_((String)"saintsdragons.command.ally.list.empty"), false);
                    continue;
                }
                for (String ally : allies) {
                    source.m_288197_(() -> Component.m_237113_((String)("  - " + ally)), false);
                }
                continue;
            }
            source.m_81352_((Component)Component.m_237110_((String)"saintsdragons.command.ally.not_dragon", (Object[])new Object[]{entity.m_5446_()}));
        }
        return entities.size();
    }

    private static int clearAllies(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection entities = EntityArgument.m_91461_(context, (String)"drake");
        int successCount = 0;
        for (Entity entity : entities) {
            if (entity instanceof DragonEntity) {
                DragonEntity dragon = (DragonEntity)entity;
                dragon.allyManager.clearAllies();
                MutableComponent message = Component.m_237110_((String)"saintsdragons.command.ally.clear.success", (Object[])new Object[]{dragon.m_5446_()});
                source.m_288197_(() -> DragonAllyCommand.lambda$clearAllies$9((Component)message), false);
                ++successCount;
                continue;
            }
            source.m_81352_((Component)Component.m_237110_((String)"saintsdragons.command.ally.not_dragon", (Object[])new Object[]{entity.m_5446_()}));
        }
        return successCount;
    }

    private static /* synthetic */ Component lambda$clearAllies$9(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$listAllies$6(Component header) {
        return header;
    }

    private static /* synthetic */ Component lambda$removeAlly$5(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$addAlly$4(Component message) {
        return message;
    }
}

