/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.navigation;

import com.leon.saintsdragons.server.entity.interfaces.AquaticDragon;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class DragonSwimMoveControl
extends MoveControl {
    private final Mob mob;
    private final float yawLimit;
    private final double accelerationScale;
    private final double speedBoost;

    public DragonSwimMoveControl(Mob mob, float yawLimitDegrees, double accelerationScale, double speedBoost) {
        super(mob);
        this.mob = mob;
        this.yawLimit = yawLimitDegrees;
        this.accelerationScale = accelerationScale;
        this.speedBoost = speedBoost;
    }

    public void m_8126_() {
        double dz;
        double dy;
        if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.mob.m_20159_() || !this.mob.m_20069_()) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            this.mob.m_21564_(0.0f);
            this.mob.m_21567_(0.0f);
            this.mob.m_21570_(0.0f);
            return;
        }
        double dx = this.f_24975_ - this.mob.m_20185_();
        double distanceSqr = dx * dx + (dy = this.f_24976_ - this.mob.m_20186_()) * dy + (dz = this.f_24977_ - this.mob.m_20189_()) * dz;
        if (distanceSqr < 2.500000277905201E-7) {
            this.mob.m_21564_(0.0f);
            this.mob.m_21567_(0.0f);
            this.f_24981_ = MoveControl.Operation.WAIT;
            return;
        }
        float targetYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.2957763671875) - 90.0f;
        this.mob.m_146922_(this.m_24991_(this.mob.m_146908_(), targetYaw, this.yawLimit));
        this.mob.f_20883_ = this.mob.m_146908_();
        this.mob.f_20885_ = this.mob.m_146908_();
        float baseSpeed = (float)(this.f_24978_ * this.mob.m_21133_(Attributes.f_22279_));
        this.mob.m_7910_(baseSpeed * 0.2f);
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        if (Math.abs(dy) > (double)1.0E-5f || Math.abs(horizontalDistance) > (double)1.0E-5f) {
            float targetPitch = -((float)(Mth.m_14136_((double)dy, (double)horizontalDistance) * 57.2957763671875));
            targetPitch = Mth.m_14036_((float)Mth.m_14177_((float)targetPitch), (float)-85.0f, (float)85.0f);
            this.mob.m_146926_(this.m_24991_(this.mob.m_146909_(), targetPitch, this.yawLimit * 0.5f));
        }
        float pitchRad = this.mob.m_146909_() * ((float)Math.PI / 180);
        float cosXRot = Mth.m_14089_((float)pitchRad);
        float sinXRot = Mth.m_14031_((float)pitchRad);
        float amplifiedSpeed = baseSpeed * 5.0f;
        this.mob.f_20902_ = cosXRot * amplifiedSpeed;
        this.mob.f_20901_ = -sinXRot * amplifiedSpeed;
        if (dy > 0.5 && horizontalDistance < 2.0) {
            this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, 0.015, 0.0));
        }
    }

    private double getNaturalSwimSpeed(Mob mob) {
        if (mob instanceof AquaticDragon) {
            AquaticDragon dragon = (AquaticDragon)mob;
            return dragon.getSwimSpeed() + this.speedBoost;
        }
        return 0.6 + this.speedBoost;
    }

    protected float m_24991_(float current, float target, float maxDelta) {
        float delta = Mth.m_14177_((float)(target - current));
        delta = Mth.m_14036_((float)delta, (float)(-maxDelta), (float)maxDelta);
        return current + delta;
    }
}

