/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.navigation;

import com.leon.saintsdragons.server.ai.navigation.DragonPathFinderGround;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DragonPathNavigateGround
extends GroundPathNavigation {
    public DragonPathNavigateGround(Mob mob, Level world) {
        super(mob, world);
    }

    @NotNull
    protected PathFinder m_5532_(int maxVisitedNodes) {
        this.f_26508_ = new WalkNodeEvaluator();
        this.f_26508_.m_77351_(true);
        return new DragonPathFinderGround(this.f_26508_, maxVisitedNodes);
    }

    protected void m_7636_() {
        Path path = Objects.requireNonNull(this.f_26496_);
        Vec3 entityPos = this.m_7475_();
        int pathLength = path.m_77398_();
        for (int i = path.m_77399_(); i < path.m_77398_(); ++i) {
            if ((double)path.m_77375_((int)i).f_77272_ == Math.floor(entityPos.f_82480_)) continue;
            pathLength = i;
            break;
        }
        Vec3 base = entityPos.m_82520_((double)(-this.f_26494_.m_20205_() * 0.5f), 0.0, (double)(-this.f_26494_.m_20205_() * 0.5f));
        Vec3 max = base.m_82520_((double)this.f_26494_.m_20205_(), (double)this.f_26494_.m_20206_(), (double)this.f_26494_.m_20205_());
        if (this.tryShortcut(path, new Vec3(this.f_26494_.m_20185_(), this.f_26494_.m_20186_(), this.f_26494_.m_20189_()), pathLength, base, max) && (this.isAt(path, 0.5f) || this.atElevationChange(path) && this.isAt(path, this.f_26494_.m_20205_() * 0.5f))) {
            path.m_77393_(path.m_77399_() + 1);
        }
        this.m_6481_(entityPos);
    }

    private boolean isAt(Path path, float threshold) {
        Vec3 pathPos = path.m_77380_((Entity)this.f_26494_);
        return Mth.m_14154_((float)((float)(this.f_26494_.m_20185_() - pathPos.f_82479_))) < threshold && Mth.m_14154_((float)((float)(this.f_26494_.m_20189_() - pathPos.f_82481_))) < threshold && Math.abs(this.f_26494_.m_20186_() - pathPos.f_82480_) < 1.0;
    }

    private boolean atElevationChange(Path path) {
        int curr = path.m_77399_();
        int end = Math.min(path.m_77398_(), curr + Mth.m_14167_((float)(this.f_26494_.m_20205_() * 0.5f)) + 1);
        int currY = path.m_77375_((int)curr).f_77272_;
        for (int i = curr + 1; i < end; ++i) {
            if (path.m_77375_((int)i).f_77272_ == currY) continue;
            return true;
        }
        return false;
    }

    private boolean tryShortcut(Path path, Vec3 entityPos, int pathLength, Vec3 base, Vec3 max) {
        int i = pathLength;
        while (--i > path.m_77399_()) {
            Vec3 vec = path.m_77382_((Entity)this.f_26494_, i).m_82546_(entityPos);
            if (!this.sweep(vec, base, max)) continue;
            path.m_77393_(i);
            return false;
        }
        return true;
    }

    private boolean sweep(Vec3 vec, Vec3 base, Vec3 max) {
        float distance = (float)vec.m_82553_();
        if (distance < 1.0E-8f) {
            return true;
        }
        if (distance < 3.0f) {
            return true;
        }
        return true;
    }

    protected boolean m_7367_(@Nonnull BlockPathTypes pathType) {
        if (pathType == BlockPathTypes.LAVA) {
            return false;
        }
        if (pathType == BlockPathTypes.WATER) {
            return this.f_26494_.m_20072_();
        }
        return pathType != BlockPathTypes.OPEN;
    }
}

