/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class RaevyxFollowOwnerGoal
extends Goal {
    private final Raevyx wyvern;
    private static final double START_FOLLOW_DIST = 16.0;
    private static final double STOP_FOLLOW_DIST = 5.0;
    private static final double TELEPORT_DIST = 500.0;
    private static final double RUN_DIST = 20.0;
    private static final double FLIGHT_TRIGGER_DIST = 30.0;
    private static final double FLIGHT_HEIGHT_DIFF = 8.0;
    private static final double LANDING_DISTANCE = 12.0;
    private static final double HOVER_HEIGHT = 3.0;
    private int pathRecalcCooldown = 0;
    private double lastOwnerX = Double.NaN;
    private double lastOwnerY = Double.NaN;
    private double lastOwnerZ = Double.NaN;

    public RaevyxFollowOwnerGoal(Raevyx wyvern) {
        this.wyvern = wyvern;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.wyvern.m_21824_() || this.wyvern.m_21827_() || this.wyvern.isSleepLocked()) {
            return false;
        }
        if (this.wyvern.m_5448_() != null && this.wyvern.m_5448_().m_6084_()) {
            return false;
        }
        LivingEntity owner = this.wyvern.m_269323_();
        if (owner == null || !owner.m_6084_()) {
            return false;
        }
        if (owner.m_9236_() != this.wyvern.m_9236_()) {
            return false;
        }
        if (this.wyvern.shouldForceOwnerFollow()) {
            return true;
        }
        double ownerDist = this.wyvern.getCachedDistanceToOwner();
        return ownerDist > 256.0;
    }

    public boolean m_8045_() {
        LivingEntity owner = this.wyvern.m_269323_();
        if (owner == null || !owner.m_6084_() || this.wyvern.m_21827_() || this.wyvern.isSleepLocked()) {
            return false;
        }
        if (this.wyvern.shouldForceOwnerFollow()) {
            return true;
        }
        if (this.wyvern.m_5448_() != null && this.wyvern.m_5448_().m_6084_()) {
            return false;
        }
        if (owner.m_9236_() != this.wyvern.m_9236_()) {
            return false;
        }
        double dist = this.wyvern.m_20280_((Entity)owner);
        return dist > 25.0;
    }

    public void m_8056_() {
        this.resetPathTracking();
        LivingEntity owner = this.wyvern.m_269323_();
        double dist = owner != null ? Math.sqrt(this.wyvern.m_20280_((Entity)owner)) : -1.0;
    }

    public void m_8037_() {
        LivingEntity owner = this.wyvern.m_269323_();
        if (owner == null) {
            return;
        }
        double distance = this.wyvern.m_20270_((Entity)owner);
        boolean ownerAirborne = this.isOwnerAirborne(owner);
        if (distance > 500.0) {
            this.wyvern.m_6021_(owner.m_20185_(), owner.m_20186_() + 3.0, owner.m_20189_());
            this.wyvern.setFlying(true);
            this.wyvern.setTakeoff(false);
            this.wyvern.setLanding(false);
            this.wyvern.setHovering(false);
            this.resetPathTracking();
            return;
        }
        this.wyvern.m_21563_().m_24960_((Entity)owner, 10.0f, 10.0f);
        boolean shouldFly = this.shouldTriggerFlight(owner, distance, ownerAirborne);
        if (shouldFly && !this.wyvern.m_29443_()) {
            this.wyvern.setFlying(true);
            this.wyvern.setTakeoff(true);
            this.wyvern.setLanding(false);
            this.wyvern.setHovering(false);
            this.resetPathTracking();
        } else if (this.wyvern.m_29443_()) {
            if (this.wyvern.shouldForceOwnerFollow() || ownerAirborne) {
                this.wyvern.setLanding(false);
                this.wyvern.setHovering(false);
            } else if (!this.wyvern.isLanding()) {
                this.wyvern.setLanding(true);
                this.wyvern.setHovering(false);
                this.wyvern.setTakeoff(false);
                this.wyvern.setFlying(false);
                this.pathRecalcCooldown = 0;
            }
        }
        if (this.wyvern.m_29443_()) {
            this.handleFlightFollowing(owner);
        } else {
            this.handleGroundFollowing(owner, distance);
        }
    }

    private void handleFlightFollowing(LivingEntity owner) {
        double targetZ;
        double targetY = owner.m_20186_() + (double)owner.m_20206_() + 3.0;
        Vec3 ownerLook = owner.m_20154_();
        double offsetX = -ownerLook.f_82479_ * 3.0;
        double offsetZ = -ownerLook.f_82481_ * 3.0;
        double verticalOffset = Math.sin((double)this.wyvern.f_19797_ * 0.2) * 0.3;
        double targetX = owner.m_20185_() + offsetX;
        double distanceToTarget = Math.sqrt(this.wyvern.m_20275_(targetX, targetY, targetZ = owner.m_20189_() + offsetZ));
        if (distanceToTarget > 1.0) {
            this.wyvern.m_21566_().m_6849_(targetX, targetY + verticalOffset, targetZ, 1.2);
        } else {
            this.wyvern.m_21573_().m_26573_();
        }
    }

    private void handleGroundFollowing(LivingEntity owner, double distance) {
        if (distance <= 5.0) {
            if (this.wyvern.getGroundMoveState() > 0) {
                this.wyvern.m_21573_().m_26573_();
                this.wyvern.setRunning(false);
                this.wyvern.setGroundMoveStateFromAI(0);
            }
            this.pathRecalcCooldown = 0;
            return;
        }
        boolean shouldRun = distance > 20.0;
        this.wyvern.setRunning(shouldRun);
        int moveState = shouldRun ? 2 : 1;
        this.wyvern.setGroundMoveStateFromAI(moveState);
        double baseSpeed = shouldRun ? 1.5 : 0.8;
        double speed = baseSpeed * (1.0 + distance / 50.0);
        speed = Math.min(speed, shouldRun ? 2.5 : 1.2);
        this.updateGroundPath(owner, speed, distance, shouldRun);
        if (this.wyvern.m_21573_().m_26577_()) {
            this.wyvern.m_21569_().m_24901_();
            this.wyvern.m_21573_().m_26573_();
            this.pathRecalcCooldown = 0;
        }
    }

    private boolean shouldTriggerFlight(LivingEntity owner, double distance, boolean ownerAirborne) {
        if (this.wyvern.m_29443_()) {
            if (this.wyvern.shouldForceOwnerFollow() || ownerAirborne) {
                return true;
            }
            return !(distance < 12.0) || !(owner.m_20186_() - this.wyvern.m_20186_() < 8.0);
        }
        if (!this.canTriggerFlight()) {
            return false;
        }
        if (this.wyvern.shouldForceOwnerFollow() || ownerAirborne) {
            return true;
        }
        if (this.wyvern.isHovering()) {
            return false;
        }
        if (distance < 7.5) {
            return false;
        }
        boolean farAway = distance > 30.0;
        boolean ownerAbove = owner.m_20186_() - this.wyvern.m_20186_() > 8.0;
        return farAway || ownerAbove;
    }

    private boolean canTriggerFlight() {
        return !this.wyvern.m_21827_() && !this.wyvern.m_6162_() && (this.wyvern.m_20096_() || this.wyvern.m_20069_()) && this.wyvern.m_20197_().isEmpty() && this.wyvern.m_6688_() == null && !this.wyvern.m_20159_() && this.wyvern.getActiveAbility() == null;
    }

    public void m_8041_() {
        this.wyvern.setRunning(false);
        this.wyvern.m_21573_().m_26573_();
        this.wyvern.setGroundMoveStateFromAI(0);
        this.wyvern.clearForcedOwnerFollow();
        this.resetPathTracking();
    }

    private void updateGroundPath(LivingEntity owner, double speed, double distance, boolean running) {
        boolean navIdle;
        if (this.pathRecalcCooldown > 0) {
            --this.pathRecalcCooldown;
        }
        boolean ownerMoved = this.ownerMovedSignificantly(owner);
        boolean bl = navIdle = this.wyvern.m_21573_().m_26571_() || !this.wyvern.m_21573_().m_26572_();
        if (navIdle || ownerMoved || this.pathRecalcCooldown <= 0) {
            if (!this.wyvern.m_21573_().m_5624_((Entity)owner, speed)) {
                this.wyvern.m_21573_().m_26519_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), speed);
            }
            this.rememberOwnerPosition(owner);
            this.pathRecalcCooldown = this.computeRepathCooldown(distance, running);
        }
    }

    private int computeRepathCooldown(double distance, boolean running) {
        int base = (int)Math.ceil(distance * (running ? 0.3 : 0.45));
        return Mth.m_14045_((int)base, (int)(running ? 4 : 6), (int)(running ? 18 : 24));
    }

    private boolean ownerMovedSignificantly(LivingEntity owner) {
        double dz;
        double dy;
        if (Double.isNaN(this.lastOwnerX)) {
            return true;
        }
        double dx = owner.m_20185_() - this.lastOwnerX;
        return dx * dx + (dy = owner.m_20186_() - this.lastOwnerY) * dy + (dz = owner.m_20189_() - this.lastOwnerZ) * dz > 1.2;
    }

    private void rememberOwnerPosition(LivingEntity owner) {
        this.lastOwnerX = owner.m_20185_();
        this.lastOwnerY = owner.m_20186_();
        this.lastOwnerZ = owner.m_20189_();
    }

    private void resetPathTracking() {
        this.pathRecalcCooldown = 0;
        this.lastOwnerX = Double.NaN;
        this.lastOwnerY = Double.NaN;
        this.lastOwnerZ = Double.NaN;
    }

    private boolean isOwnerAirborne(LivingEntity owner) {
        Entity vehicle;
        if (owner == null || owner.m_9236_() != this.wyvern.m_9236_()) {
            return false;
        }
        if (owner.m_20159_() && (vehicle = owner.m_20202_()) != null && !vehicle.m_20096_()) {
            return true;
        }
        if (owner.m_20096_()) {
            return false;
        }
        BlockPos pos = owner.m_20183_();
        int groundY = owner.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_();
        return owner.m_20186_() - (double)groundY > 4.0;
    }
}

