/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.nulljaw;

import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class NulljawFollowOwnerGoal
extends Goal {
    private static final double START_DISTANCE = 20.0;
    private static final double STOP_DISTANCE = 16.0;
    private static final double RUN_DISTANCE = 25.0;
    private static final double TELEPORT_DISTANCE = 64.0;
    private final Nulljaw drake;
    private int pathRecalcCooldown;
    private double lastOwnerX = Double.NaN;
    private double lastOwnerY = Double.NaN;
    private double lastOwnerZ = Double.NaN;

    public NulljawFollowOwnerGoal(Nulljaw drake) {
        this.drake = drake;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.drake.m_21824_() || this.drake.m_21827_() || this.drake.m_20160_()) {
            return false;
        }
        LivingEntity owner = this.drake.m_269323_();
        if (owner == null || !owner.m_6084_() || owner.m_9236_() != this.drake.m_9236_()) {
            return false;
        }
        if (this.drake.m_5448_() != null) {
            return false;
        }
        return this.drake.m_20280_((Entity)owner) > 400.0;
    }

    public boolean m_8045_() {
        if (!this.drake.m_21824_() || this.drake.m_21827_() || this.drake.m_20160_()) {
            return false;
        }
        LivingEntity owner = this.drake.m_269323_();
        if (owner == null || !owner.m_6084_() || owner.m_9236_() != this.drake.m_9236_()) {
            return false;
        }
        if (this.drake.m_5448_() != null) {
            return false;
        }
        return this.drake.m_20280_((Entity)owner) > 256.0;
    }

    public void m_8056_() {
        this.resetPathTracking();
        this.drake.setAccelerating(false);
    }

    public void m_8041_() {
        this.drake.m_21573_().m_26573_();
        this.drake.setAccelerating(false);
        this.resetPathTracking();
    }

    public void m_8037_() {
        LivingEntity owner = this.drake.m_269323_();
        if (owner == null) {
            return;
        }
        double distance = this.drake.m_20270_((Entity)owner);
        if (distance > 64.0) {
            this.drake.m_6021_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
            this.drake.m_21573_().m_26573_();
            this.drake.setAccelerating(false);
            this.resetPathTracking();
            return;
        }
        this.drake.m_21563_().m_24960_((Entity)owner, 10.0f, (float)this.drake.m_8132_());
        if (distance <= 16.0) {
            this.drake.m_21573_().m_26573_();
            this.drake.setAccelerating(false);
            return;
        }
        boolean shouldRun = distance > 25.0;
        this.drake.setAccelerating(shouldRun);
        double speed = shouldRun ? 1.35 : 0.85;
        this.updateGroundPath(owner, speed, distance, shouldRun);
    }

    private void updateGroundPath(LivingEntity owner, double speed, double distance, boolean running) {
        boolean navIdle;
        if (this.pathRecalcCooldown > 0) {
            --this.pathRecalcCooldown;
        }
        boolean ownerMoved = this.ownerMovedSignificantly(owner);
        boolean bl = navIdle = this.drake.m_21573_().m_26571_() || !this.drake.m_21573_().m_26572_();
        if (navIdle || ownerMoved || this.pathRecalcCooldown <= 0) {
            double effectiveSpeed;
            double d = effectiveSpeed = this.drake.m_20069_() ? speed * 1.3 : speed;
            if (!this.drake.m_21573_().m_5624_((Entity)owner, effectiveSpeed)) {
                this.drake.m_21573_().m_26519_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), effectiveSpeed);
            }
            this.rememberOwnerPosition(owner);
            this.pathRecalcCooldown = this.computeRepathCooldown(distance, running);
        }
    }

    private int computeRepathCooldown(double distance, boolean running) {
        int base = (int)Math.ceil(distance * (running ? 0.4 : 0.55));
        return Mth.m_14045_((int)base, (int)(running ? 4 : 6), (int)(running ? 16 : 24));
    }

    private void rememberOwnerPosition(LivingEntity owner) {
        this.lastOwnerX = owner.m_20185_();
        this.lastOwnerY = owner.m_20186_();
        this.lastOwnerZ = owner.m_20189_();
    }

    private boolean ownerMovedSignificantly(LivingEntity owner) {
        double dz;
        double dy;
        if (Double.isNaN(this.lastOwnerX)) {
            return true;
        }
        double dx = owner.m_20185_() - this.lastOwnerX;
        return dx * dx + (dy = owner.m_20186_() - this.lastOwnerY) * dy + (dz = owner.m_20189_() - this.lastOwnerZ) * dz > 1.0;
    }

    private void resetPathTracking() {
        this.pathRecalcCooldown = 0;
        this.lastOwnerX = Double.NaN;
        this.lastOwnerY = Double.NaN;
        this.lastOwnerZ = Double.NaN;
    }
}

