/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.nulljaw;

import com.leon.saintsdragons.common.registry.nulljaw.NulljawAbilities;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;

public class NulljawCombatGoal
extends Goal {
    private static final double CHASE_SPEED = 1.5;
    private static final double BITE_RANGE = 5.0;
    private static final double HORN_RANGE = 5.0;
    private static final double CLAW_RANGE = 3.5;
    private static final int MIN_ATTACK_COOLDOWN_TICKS = 20;
    private final Nulljaw drake;
    private int attackCooldown;
    private int pathRecalcCooldown = 0;
    private double lastTargetX;
    private double lastTargetY;
    private double lastTargetZ;
    private boolean hasUsedRoarOpener = false;
    private int roarOpenerDelay = 0;

    public NulljawCombatGoal(Nulljaw drake) {
        this.drake = drake;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.drake.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.drake.m_20160_() || this.drake.m_21827_()) {
            return false;
        }
        return this.isWithinAggroRange(target);
    }

    public boolean m_8045_() {
        LivingEntity target = this.drake.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.drake.m_20160_() || this.drake.m_21827_()) {
            return false;
        }
        return this.isWithinAggroRange(target);
    }

    public void m_8056_() {
        this.attackCooldown = 0;
        this.drake.m_21561_(true);
        if (this.drake.isPhaseTwoActive()) {
            this.hasUsedRoarOpener = false;
            this.roarOpenerDelay = 5;
        } else {
            this.hasUsedRoarOpener = true;
            this.roarOpenerDelay = 0;
        }
        LivingEntity target = this.drake.m_5448_();
        if (target != null) {
            this.drake.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.drake.m_21573_().m_5624_((Entity)target, 1.5);
            this.rememberTargetPosition(target);
        }
    }

    public void m_8041_() {
        this.drake.m_21573_().m_26573_();
        this.drake.m_21561_(false);
        this.pathRecalcCooldown = 0;
        this.hasUsedRoarOpener = false;
        this.roarOpenerDelay = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if ((target = this.drake.m_5448_()) == null) {
            return;
        }
        this.drake.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (!this.hasUsedRoarOpener) {
            if (this.roarOpenerDelay > 0) {
                --this.roarOpenerDelay;
                this.updateChasePath(target);
            } else {
                this.drake.combatManager.tryUseAbility(NulljawAbilities.NULLJAW_ROAR);
                this.hasUsedRoarOpener = true;
                this.attackCooldown = 100;
            }
            this.updateChasePath(target);
            return;
        }
        double gap = this.getGapToTarget(target);
        boolean hasLineOfSight = this.drake.m_21574_().m_148306_((Entity)target);
        if (gap <= 5.0) {
            if (gap <= 5.0 || this.isPerformingAttack()) {
                this.drake.m_21573_().m_26573_();
                this.pathRecalcCooldown = 0;
            } else {
                this.updateChasePath(target);
            }
            this.tryPerformAttacks(target);
        } else if (!this.isPerformingAttack()) {
            this.updateChasePath(target);
        }
    }

    private void tryPerformAttacks(LivingEntity target) {
        if (this.attackCooldown > 0 || this.isPerformingAttack()) {
            return;
        }
        if (!this.drake.m_21574_().m_148306_((Entity)target)) {
            return;
        }
        DragonAbilityType<Nulljaw, ?> ability = this.choosePrimaryAttack(target);
        if (ability != null && this.drake.combatManager.canStart(ability)) {
            this.drake.combatManager.tryUseAbility(ability);
            this.attackCooldown = 20;
        }
    }

    private DragonAbilityType<Nulljaw, ?> choosePrimaryAttack(LivingEntity target) {
        double gap = this.getGapToTarget(target);
        boolean phaseTwo = this.drake.isPhaseTwoActive();
        if (gap <= 3.5) {
            if (phaseTwo && this.drake.m_217043_().m_188501_() < 0.6f) {
                return NulljawAbilities.NULLJAW_CLAW;
            }
            return phaseTwo ? NulljawAbilities.NULLJAW_BITE2 : NulljawAbilities.NULLJAW_BITE;
        }
        if (gap <= 5.0) {
            return phaseTwo ? NulljawAbilities.NULLJAW_BITE2 : NulljawAbilities.NULLJAW_BITE;
        }
        if (gap <= 5.0) {
            return NulljawAbilities.NULLJAW_HORN_GORE;
        }
        return null;
    }

    private boolean isPerformingAttack() {
        return this.drake.isAbilityActive(NulljawAbilities.NULLJAW_BITE) || this.drake.isAbilityActive(NulljawAbilities.NULLJAW_BITE2) || this.drake.isAbilityActive(NulljawAbilities.NULLJAW_CLAW) || this.drake.isAbilityActive(NulljawAbilities.NULLJAW_HORN_GORE) || this.drake.isAbilityActive(NulljawAbilities.NULLJAW_ROAR);
    }

    private boolean isWithinAggroRange(LivingEntity target) {
        double followRange = this.drake.m_21133_(Attributes.f_22277_);
        if (followRange <= 0.0) {
            followRange = 16.0;
        }
        double maxDistanceSq = followRange * followRange;
        return this.drake.m_20280_((Entity)target) <= maxDistanceSq;
    }

    private double getAttackReachSqr(LivingEntity target) {
        double combinedRadii = (double)(this.drake.m_20205_() + target.m_20205_()) * 0.5;
        double reach = 5.0 + combinedRadii;
        return reach * reach;
    }

    private double getGapToTarget(LivingEntity target) {
        double distance = this.drake.m_20270_((Entity)target);
        double combinedRadii = (double)(this.drake.m_20205_() + target.m_20205_()) * 0.5;
        return Math.max(0.0, distance - combinedRadii);
    }

    private void updateChasePath(LivingEntity target) {
        if (--this.pathRecalcCooldown <= 0 || this.targetMovedSignificantly(target)) {
            this.rememberTargetPosition(target);
            double distance = this.drake.m_20270_((Entity)target);
            this.pathRecalcCooldown = Mth.m_14045_((int)((int)(distance * 0.6)), (int)5, (int)20);
            this.drake.m_21573_().m_5624_((Entity)target, 1.5);
        }
    }

    private void rememberTargetPosition(LivingEntity target) {
        this.lastTargetX = target.m_20185_();
        this.lastTargetY = target.m_20186_();
        this.lastTargetZ = target.m_20189_();
    }

    private boolean targetMovedSignificantly(LivingEntity target) {
        double dz;
        double dy;
        double dx = target.m_20185_() - this.lastTargetX;
        return dx * dx + (dy = target.m_20186_() - this.lastTargetY) * dy + (dz = target.m_20189_() - this.lastTargetZ) * dz > 4.0;
    }
}

