/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.ignivorus;

import com.leon.saintsdragons.common.registry.ignivorus.IgnivorusAbilities;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;

public class IgnivorusGroundCombatGoal
extends Goal {
    private final Ignivorus dragon;
    private final double meleeEngageRange = 6.0;
    private final double fireBreathMinRange = 32.0;
    private final double chaseSpeed = 1.75;
    private int attackCooldown = 0;
    private int pathRecalcCooldown = 0;
    private double lastTargetX;
    private double lastTargetY;
    private double lastTargetZ;
    private boolean hasUsedUltimateOpener = false;
    private int ultimateOpenerDelay = 0;
    private int breathCooldown = 0;
    private static final int BREATH_COOLDOWN_TICKS = 3600;

    public IgnivorusGroundCombatGoal(Ignivorus dragon) {
        this.dragon = dragon;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Player player;
        LivingEntity target = this.dragon.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
            return false;
        }
        if (this.dragon.m_20160_() || this.dragon.m_21827_()) {
            return false;
        }
        if (this.isTargetAirborne(target)) {
            return false;
        }
        return !(this.dragon.m_20280_((Entity)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean m_8045_() {
        Player player;
        LivingEntity target = this.dragon.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
            return false;
        }
        if (this.dragon.m_20160_() || this.dragon.m_21827_()) {
            return false;
        }
        if (this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_FIRE_BREATH) || this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_ULTIMATE)) {
            return true;
        }
        if (this.isTargetAirborne(target)) {
            return false;
        }
        return !(this.dragon.m_20280_((Entity)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        this.dragon.m_21573_().m_26573_();
        this.dragon.m_21561_(false);
        this.dragon.setGroundMoveStateFromAI(0);
        this.cancelFireBreathIfActive();
        this.pathRecalcCooldown = 0;
        this.hasUsedUltimateOpener = false;
        this.ultimateOpenerDelay = 0;
    }

    public void m_8056_() {
        this.dragon.m_21561_(true);
        this.dragon.setGroundMoveStateFromAI(2);
        this.dragon.markLandedNow();
        this.dragon.setHovering(false);
        this.dragon.setLanding(false);
        this.dragon.setTakeoff(false);
        if (this.dragon.m_21824_() && this.dragon.m_269323_() != null) {
            this.hasUsedUltimateOpener = true;
            this.ultimateOpenerDelay = 0;
        } else {
            this.hasUsedUltimateOpener = false;
            this.ultimateOpenerDelay = 5;
        }
        LivingEntity target = this.dragon.m_5448_();
        if (target != null) {
            this.dragon.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.dragon.m_21573_().m_5624_((Entity)target, 1.75);
            this.rememberTargetPosition(target);
        }
    }

    public void m_8037_() {
        LivingEntity target;
        if (this.dragon.m_29443_() || this.dragon.isHovering() || this.dragon.isTakeoff()) {
            this.dragon.markLandedNow();
            this.dragon.setHovering(false);
            this.dragon.setLanding(false);
            this.dragon.setTakeoff(false);
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.breathCooldown > 0) {
            --this.breathCooldown;
        }
        if ((target = this.dragon.m_5448_()) == null || !target.m_6084_()) {
            this.cancelFireBreathIfActive();
            this.updateGroundMoveState();
            return;
        }
        this.dragon.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (!this.hasUsedUltimateOpener) {
            if (this.ultimateOpenerDelay > 0) {
                --this.ultimateOpenerDelay;
                this.updateChasePath(target);
                this.updateGroundMoveState();
                return;
            }
            this.dragon.combatManager.tryUseAbility(IgnivorusAbilities.IGNIVORUS_ULTIMATE);
            this.hasUsedUltimateOpener = true;
            this.attackCooldown = this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_ULTIMATE) ? 180 : 0;
        }
        double gap = this.getGapToTarget(target);
        boolean hasLineOfSight = this.dragon.m_21574_().m_148306_((Entity)target);
        if (gap > 32.0 && hasLineOfSight && this.breathCooldown <= 0) {
            if (!this.isCurrentlyAttacking()) {
                this.dragon.m_21573_().m_26573_();
                this.pathRecalcCooldown = 0;
            }
            this.tryAttack(target);
        } else if (gap > 6.0) {
            if (!this.isCurrentlyAttacking()) {
                this.updateChasePath(target);
            }
        } else {
            this.dragon.m_21573_().m_26573_();
            this.pathRecalcCooldown = 0;
            this.tryAttack(target);
        }
        this.updateGroundMoveState();
    }

    private boolean isCurrentlyAttacking() {
        return this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_BITE) || this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_BODY_SLAM) || this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_FIRE_BREATH) || this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_ULTIMATE);
    }

    private void cancelFireBreathIfActive() {
        if (this.dragon.m_20160_()) {
            return;
        }
        if (this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_FIRE_BREATH)) {
            this.dragon.forceEndAbility(IgnivorusAbilities.IGNIVORUS_FIRE_BREATH);
        }
    }

    private void tryAttack(LivingEntity target) {
        if (this.attackCooldown > 0 || this.isCurrentlyAttacking()) {
            return;
        }
        if (!this.dragon.m_21574_().m_148306_((Entity)target)) {
            return;
        }
        double gap = this.getGapToTarget(target);
        if (gap > 32.0 && this.breathCooldown <= 0) {
            this.dragon.combatManager.tryUseAbility(IgnivorusAbilities.IGNIVORUS_FIRE_BREATH);
            this.attackCooldown = 60;
            this.breathCooldown = 3600;
        } else if (gap <= 6.0) {
            if (this.dragon.m_217043_().m_188499_()) {
                this.dragon.combatManager.tryUseAbility(IgnivorusAbilities.IGNIVORUS_BODY_SLAM);
                this.attackCooldown = 25;
            } else {
                this.dragon.combatManager.tryUseAbility(IgnivorusAbilities.IGNIVORUS_BITE);
                this.attackCooldown = 20;
            }
        }
    }

    private double getGapToTarget(LivingEntity target) {
        double centerDistance = this.dragon.m_20270_((Entity)target);
        double combinedRadii = (double)(this.dragon.m_20205_() + target.m_20205_()) * 0.5;
        return Math.max(0.0, centerDistance - combinedRadii);
    }

    private double getMaxAggroDistanceSqr() {
        double followRange = this.dragon.m_21133_(Attributes.f_22277_);
        if (followRange <= 0.0) {
            followRange = 32.0;
        }
        return followRange * followRange;
    }

    private void updateChasePath(LivingEntity target) {
        if (--this.pathRecalcCooldown <= 0 || this.targetMovedSignificantly(target)) {
            this.rememberTargetPosition(target);
            double distance = this.dragon.m_20270_((Entity)target);
            this.pathRecalcCooldown = Mth.m_14045_((int)((int)(distance * 0.6)), (int)5, (int)20);
            this.dragon.m_21573_().m_5624_((Entity)target, 1.75);
        }
    }

    private void rememberTargetPosition(LivingEntity target) {
        this.lastTargetX = target.m_20185_();
        this.lastTargetY = target.m_20186_();
        this.lastTargetZ = target.m_20189_();
    }

    private boolean targetMovedSignificantly(LivingEntity target) {
        double dz;
        double dy;
        double dx = target.m_20185_() - this.lastTargetX;
        return dx * dx + (dy = target.m_20186_() - this.lastTargetY) * dy + (dz = target.m_20189_() - this.lastTargetZ) * dz > 4.0;
    }

    private void updateGroundMoveState() {
        if (!this.dragon.m_29443_() && this.dragon.m_20096_() && this.dragon.m_21573_().m_26572_()) {
            this.dragon.setGroundMoveStateFromAI(2);
        } else {
            this.dragon.setGroundMoveStateFromAI(0);
        }
    }

    private boolean isTargetAirborne(LivingEntity target) {
        if (target.m_20096_()) {
            return false;
        }
        if (target.m_20159_() && target.m_20202_() != null) {
            return true;
        }
        double groundY = this.dragon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, target.m_20183_()).m_123342_();
        return target.m_20186_() - groundY > 8.0;
    }
}

