/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.ignivorus;

import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class IgnivorusFollowOwnerGoal
extends Goal {
    private final Ignivorus dragon;
    private static final double START_FOLLOW_DIST = 20.0;
    private static final double STOP_FOLLOW_DIST = 16.0;
    private static final double TELEPORT_DIST = 500.0;
    private static final double RUN_DIST = 25.0;
    private static final double FLIGHT_TRIGGER_DIST = 20.0;
    private static final double FLIGHT_HEIGHT_DIFF = 8.0;
    private static final double LANDING_DISTANCE = 12.0;
    private static final double HOVER_HEIGHT = 3.0;
    private int pathRecalcCooldown = 0;
    private double lastOwnerX = Double.NaN;
    private double lastOwnerY = Double.NaN;
    private double lastOwnerZ = Double.NaN;

    public IgnivorusFollowOwnerGoal(Ignivorus dragon) {
        this.dragon = dragon;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.dragon.m_21824_() || this.dragon.m_21827_()) {
            return false;
        }
        if (this.dragon.m_5448_() != null && this.dragon.m_5448_().m_6084_()) {
            return false;
        }
        LivingEntity owner = this.dragon.m_269323_();
        if (owner == null || !owner.m_6084_()) {
            return false;
        }
        if (owner.m_9236_() != this.dragon.m_9236_()) {
            return false;
        }
        double distSq = this.dragon.m_20280_((Entity)owner);
        return distSq > 400.0;
    }

    public boolean m_8045_() {
        LivingEntity owner = this.dragon.m_269323_();
        if (owner == null || !owner.m_6084_() || this.dragon.m_21827_()) {
            return false;
        }
        if (this.dragon.m_5448_() != null && this.dragon.m_5448_().m_6084_()) {
            return false;
        }
        if (owner.m_9236_() != this.dragon.m_9236_()) {
            return false;
        }
        double dist = this.dragon.m_20280_((Entity)owner);
        return dist > 256.0;
    }

    public void m_8056_() {
        this.resetPathTracking();
    }

    public void m_8037_() {
        LivingEntity owner = this.dragon.m_269323_();
        if (owner == null) {
            return;
        }
        double distance = this.dragon.m_20270_((Entity)owner);
        if (distance > 500.0) {
            this.dragon.m_6021_(owner.m_20185_(), owner.m_20186_() + 3.0, owner.m_20189_());
            this.dragon.setFlying(true);
            this.dragon.setTakeoff(false);
            this.dragon.setLanding(false);
            this.dragon.setHovering(false);
            this.resetPathTracking();
            return;
        }
        this.dragon.m_21563_().m_24960_((Entity)owner, 10.0f, 10.0f);
        boolean shouldFly = this.shouldTriggerFlight(owner, distance);
        if (shouldFly && !this.dragon.m_29443_()) {
            this.dragon.setFlying(true);
            this.dragon.setTakeoff(true);
            this.dragon.setLanding(false);
            this.dragon.setHovering(false);
            this.resetPathTracking();
        } else if (this.dragon.m_29443_() && distance < 24.0 && owner.m_20096_()) {
            this.dragon.setLanding(true);
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
            this.pathRecalcCooldown = 0;
        } else if (shouldFly || this.dragon.m_29443_()) {
            // empty if block
        }
        if (this.dragon.m_29443_()) {
            this.handleFlightFollowing(owner);
        } else {
            this.handleGroundFollowing(owner, distance);
        }
    }

    private void handleFlightFollowing(LivingEntity owner) {
        double targetZ;
        double targetY = owner.m_20186_() + (double)owner.m_20206_() + 3.0;
        Vec3 ownerLook = owner.m_20154_();
        double offsetX = -ownerLook.f_82479_ * 3.0;
        double offsetZ = -ownerLook.f_82481_ * 3.0;
        double verticalOffset = Math.sin((double)this.dragon.f_19797_ * 0.2) * 0.3;
        double targetX = owner.m_20185_() + offsetX;
        double distanceToTarget = Math.sqrt(this.dragon.m_20275_(targetX, targetY, targetZ = owner.m_20189_() + offsetZ));
        if (distanceToTarget > 1.0) {
            this.dragon.m_21566_().m_6849_(targetX, targetY + verticalOffset, targetZ, 1.2);
        } else {
            this.dragon.m_21573_().m_26573_();
        }
    }

    private void handleGroundFollowing(LivingEntity owner, double distance) {
        if (distance <= 16.0) {
            if (this.dragon.getGroundMoveState() > 0) {
                this.dragon.m_21573_().m_26573_();
                this.dragon.setRunning(false);
                this.dragon.setGroundMoveStateFromAI(0);
            }
            this.pathRecalcCooldown = 0;
            return;
        }
        boolean shouldRun = distance > 25.0;
        this.dragon.setRunning(shouldRun);
        int moveState = shouldRun ? 2 : 1;
        this.dragon.setGroundMoveStateFromAI(moveState);
        double baseSpeed = shouldRun ? 1.5 : 0.8;
        double speed = baseSpeed * (1.0 + distance / 50.0);
        speed = Math.min(speed, shouldRun ? 2.5 : 1.2);
        this.updateGroundPath(owner, speed, distance, shouldRun);
        if (this.dragon.m_21573_().m_26577_()) {
            this.dragon.m_21569_().m_24901_();
            this.dragon.m_21573_().m_26573_();
            this.pathRecalcCooldown = 0;
        }
    }

    private boolean shouldTriggerFlight(LivingEntity owner, double distance) {
        if (this.dragon.m_29443_()) {
            return !(distance < 12.0) || !owner.m_20096_();
        }
        if (this.dragon.isHovering()) {
            boolean ownerAirborne = !owner.m_20096_();
            boolean ownerFarEnough = distance > 32.0;
            boolean ownerAbove = owner.m_20186_() - this.dragon.m_20186_() > 4.0;
            return ownerAirborne || ownerFarEnough || ownerAbove;
        }
        if (!this.canTriggerFlight()) {
            return false;
        }
        if (distance < 24.0) {
            return false;
        }
        boolean farAway = distance > 20.0;
        boolean ownerAbove = owner.m_20186_() - this.dragon.m_20186_() > 8.0;
        return farAway || ownerAbove;
    }

    private boolean canTriggerFlight() {
        return !this.dragon.m_21827_() && !this.dragon.m_6162_() && (this.dragon.m_20096_() || this.dragon.m_20069_()) && this.dragon.m_20197_().isEmpty() && this.dragon.m_6688_() == null && !this.dragon.m_20159_() && this.dragon.getActiveAbility() == null;
    }

    public void m_8041_() {
        this.dragon.setRunning(false);
        this.dragon.m_21573_().m_26573_();
        this.dragon.setGroundMoveStateFromAI(0);
        this.resetPathTracking();
    }

    private void updateGroundPath(LivingEntity owner, double speed, double distance, boolean running) {
        boolean navIdle;
        if (this.pathRecalcCooldown > 0) {
            --this.pathRecalcCooldown;
        }
        boolean ownerMoved = this.ownerMovedSignificantly(owner);
        boolean bl = navIdle = this.dragon.m_21573_().m_26571_() || !this.dragon.m_21573_().m_26572_();
        if (navIdle || ownerMoved || this.pathRecalcCooldown <= 0) {
            if (!this.dragon.m_21573_().m_5624_((Entity)owner, speed)) {
                this.dragon.m_21573_().m_26519_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), speed);
            }
            this.rememberOwnerPosition(owner);
            this.pathRecalcCooldown = this.computeRepathCooldown(distance, running);
        }
    }

    private int computeRepathCooldown(double distance, boolean running) {
        int base = (int)Math.ceil(distance * (running ? 0.3 : 0.45));
        return Mth.m_14045_((int)base, (int)(running ? 4 : 6), (int)(running ? 18 : 24));
    }

    private boolean ownerMovedSignificantly(LivingEntity owner) {
        double dz;
        double dy;
        if (Double.isNaN(this.lastOwnerX)) {
            return true;
        }
        double dx = owner.m_20185_() - this.lastOwnerX;
        return dx * dx + (dy = owner.m_20186_() - this.lastOwnerY) * dy + (dz = owner.m_20189_() - this.lastOwnerZ) * dz > 1.2;
    }

    private void rememberOwnerPosition(LivingEntity owner) {
        this.lastOwnerX = owner.m_20185_();
        this.lastOwnerY = owner.m_20186_();
        this.lastOwnerZ = owner.m_20189_();
    }

    private void resetPathTracking() {
        this.pathRecalcCooldown = 0;
        this.lastOwnerX = Double.NaN;
        this.lastOwnerY = Double.NaN;
        this.lastOwnerZ = Double.NaN;
    }
}

