/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.ignivorus;

import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class IgnivorusFlightGoal
extends Goal {
    private final Ignivorus dragon;
    private Vec3 targetPosition;
    private int stuckCounter = 0;
    private int timeSinceTargetChange = 0;
    private static final int LANDING_COOLDOWN_TICKS = 60;
    private long lastLandingTime = 0L;
    private int flightDecisionCooldown = 0;

    public IgnivorusFlightGoal(Ignivorus dragon) {
        this.dragon = dragon;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.flightDecisionCooldown = 0;
    }

    public boolean m_8036_() {
        boolean shouldFly;
        if (this.dragon.isLanding()) {
            return false;
        }
        if (this.dragon.m_20160_() || this.dragon.m_20159_() || this.dragon.m_21827_()) {
            return false;
        }
        if (this.dragon.m_21824_() && !this.isOverDanger()) {
            return false;
        }
        long currentTime = this.dragon.m_9236_().m_46467_();
        int cooldown = 60;
        if (!this.dragon.m_29443_() && currentTime - this.lastLandingTime < (long)cooldown) {
            return false;
        }
        int decisionInterval = this.flightDecisionInterval();
        if (this.flightDecisionCooldown > 0) {
            --this.flightDecisionCooldown;
            if (this.flightDecisionCooldown > 0) {
                return false;
            }
        }
        if (shouldFly = this.isOverDanger() ? true : (this.dragon.m_29443_() ? this.shouldKeepFlying() : this.shouldTakeOff())) {
            this.targetPosition = this.findFlightTarget();
            this.flightDecisionCooldown = this.nextDecisionCooldown(decisionInterval);
            return true;
        }
        this.flightDecisionCooldown = this.nextDecisionCooldown(decisionInterval);
        return false;
    }

    public boolean m_8045_() {
        if (this.dragon.isLanding()) {
            return false;
        }
        if (this.dragon.m_21827_() || this.dragon.m_20160_()) {
            return false;
        }
        if (this.dragon.m_21824_() && !this.isOverDanger()) {
            this.dragon.setGoingUp(false);
            this.dragon.setGoingDown(false);
            this.dragon.setLanding(true);
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
            this.dragon.setTakeoff(false);
            return false;
        }
        LivingEntity target = this.dragon.m_5448_();
        if (target != null && target.m_6084_()) {
            return false;
        }
        if (this.dragon.m_29443_() && !this.shouldKeepFlying() && !this.isOverDanger()) {
            this.dragon.setLanding(true);
            this.dragon.setFlying(false);
            this.dragon.setTakeoff(false);
            this.dragon.setHovering(false);
            return false;
        }
        if (this.dragon.m_29443_() && this.dragon.m_20096_() && this.timeSinceTargetChange > 5) {
            this.dragon.setLanding(true);
            this.dragon.setFlying(false);
            this.dragon.setTakeoff(false);
            this.dragon.setHovering(false);
            this.dragon.markLandedNow();
            return false;
        }
        return this.dragon.m_29443_() && this.targetPosition != null && this.dragon.m_20238_(this.targetPosition) > 9.0;
    }

    public void m_8056_() {
        this.dragon.setFlying(true);
        this.dragon.setLanding(false);
        this.dragon.setHovering(false);
        if (this.targetPosition != null) {
            this.dragon.m_21566_().m_6849_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, (double)this.dragon.getFlightSpeed());
        }
    }

    public void m_8037_() {
        ++this.timeSinceTargetChange;
        if (this.dragon.isLanding()) {
            return;
        }
        if (this.dragon.m_29443_() && this.dragon.m_20096_() && this.timeSinceTargetChange > 5) {
            this.dragon.setLanding(true);
            this.dragon.setFlying(false);
            this.dragon.setTakeoff(false);
            this.dragon.setHovering(false);
            this.dragon.markLandedNow();
            return;
        }
        if (this.dragon.m_21824_() && !this.isOverDanger()) {
            this.dragon.setLanding(true);
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
            this.dragon.setTakeoff(false);
            return;
        }
        boolean needNewTarget = false;
        if (this.targetPosition == null) {
            needNewTarget = true;
        } else {
            double distanceToTarget = this.dragon.m_20238_(this.targetPosition);
            if (distanceToTarget < 64.0) {
                needNewTarget = true;
            }
            if (this.dragon.f_19862_ && distanceToTarget > 25.0) {
                needNewTarget = true;
                this.stuckCounter = 0;
            }
            if (this.dragon.f_19862_ && this.timeSinceTargetChange % 5 == 0) {
                ++this.stuckCounter;
                if (this.stuckCounter > 2) {
                    needNewTarget = true;
                    this.stuckCounter = 0;
                }
            } else if (!this.dragon.f_19862_) {
                this.stuckCounter = Math.max(0, this.stuckCounter - 1);
            }
            if (this.dragon.f_19797_ % 20 == 0 && !this.isValidFlightTarget(this.targetPosition)) {
                needNewTarget = true;
            }
            if (this.timeSinceTargetChange > 400) {
                needNewTarget = true;
            }
        }
        if (needNewTarget) {
            this.targetPosition = this.findFlightTarget();
            this.timeSinceTargetChange = 0;
            this.dragon.m_21566_().m_6849_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, (double)this.dragon.getFlightSpeed());
        }
    }

    public void m_8041_() {
        this.targetPosition = null;
        this.stuckCounter = 0;
        this.timeSinceTargetChange = 0;
        this.dragon.m_21573_().m_26573_();
        if (!this.dragon.m_29443_()) {
            this.lastLandingTime = this.dragon.m_9236_().m_46467_();
        }
    }

    private Vec3 findFlightTarget() {
        Vec3 dragonPos = this.dragon.m_20182_();
        Vec3 anchor = this.getFlightAnchor();
        for (int attempts = 0; attempts < 16; ++attempts) {
            Vec3 candidate = this.generateFlightCandidate(anchor, dragonPos, attempts);
            if (!this.isValidFlightTarget(candidate)) continue;
            return candidate;
        }
        return new Vec3(anchor.f_82479_, this.findSafeFlightHeight(anchor.f_82479_, anchor.f_82481_, false), anchor.f_82481_);
    }

    private Vec3 generateFlightCandidate(Vec3 anchor, Vec3 dragonPos, int attempt) {
        Vec3 candidate;
        boolean isStuck = this.dragon.f_19862_ || this.stuckCounter > 0;
        boolean tethered = this.isTamedWander();
        if (tethered) {
            double min = 15.0 + this.dragon.m_217043_().m_188500_() * 10.0;
            double max = 35.0 + this.dragon.m_217043_().m_188500_() * 15.0;
            double angle = this.dragon.m_217043_().m_188500_() * Math.PI * 2.0;
            double radius = min + this.dragon.m_217043_().m_188500_() * (max - min);
            double cx = anchor.f_82479_ + Math.cos(angle) * radius;
            double cz = anchor.f_82481_ + Math.sin(angle) * radius;
            double targetY = this.findSafeFlightHeight(cx, cz, true);
            candidate = new Vec3(cx, targetY, cz);
        } else {
            float maxRot = isStuck ? 360.0f : 180.0f;
            float range = isStuck ? 30.0f + this.dragon.m_217043_().m_188501_() * 40.0f : 50.0f + this.dragon.m_217043_().m_188501_() * 70.0f;
            float yRotOffset = isStuck && attempt < 8 ? (float)Math.toRadians(180.0f + this.dragon.m_217043_().m_188501_() * 120.0f - 60.0f) : (float)Math.toRadians(this.dragon.m_217043_().m_188501_() * maxRot - maxRot / 2.0f);
            float xRotOffset = (float)Math.toRadians((this.dragon.m_217043_().m_188501_() - 0.5f) * 30.0f);
            Vec3 lookVec = this.dragon.m_20154_();
            Vec3 targetVec = lookVec.m_82490_((double)range).m_82524_(yRotOffset).m_82496_(xRotOffset);
            Vec3 raw = dragonPos.m_82549_(targetVec);
            double targetY = this.findSafeFlightHeight(raw.f_82479_, raw.f_82481_, false);
            candidate = new Vec3(raw.f_82479_, targetY, raw.f_82481_);
        }
        if (!this.dragon.m_9236_().m_46749_(BlockPos.m_274446_((Position)candidate))) {
            return null;
        }
        return candidate;
    }

    private double findSafeFlightHeight(double x, double z, boolean tethered) {
        double capAboveGround;
        int groundY;
        int ix = (int)x;
        int iz = (int)z;
        BlockPos dragonPos = this.dragon.m_20183_();
        boolean canSeeSky = this.dragon.m_9236_().m_45527_(dragonPos);
        if (canSeeSky) {
            groundY = this.dragon.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ix, iz);
            capAboveGround = tethered ? 40.0 : 60.0;
        } else {
            int surfaceY = this.dragon.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ix, iz);
            groundY = this.findGroundInCave(x, surfaceY, z);
            int ceilingY = this.findCeilingInCave(x, groundY, z);
            double caveFactor = tethered ? 0.45 + this.dragon.m_217043_().m_188500_() * 0.2 : 0.55 + this.dragon.m_217043_().m_188500_() * 0.2;
            capAboveGround = (double)(ceilingY - groundY) * caveFactor;
            capAboveGround = Math.max(capAboveGround, tethered ? 10.0 : 15.0);
        }
        double base = tethered ? (canSeeSky ? 15.0 + this.dragon.m_217043_().m_188500_() * 15.0 : 8.0 + this.dragon.m_217043_().m_188500_() * 12.0) : (canSeeSky ? 20.0 + this.dragon.m_217043_().m_188500_() * 25.0 : 10.0 + this.dragon.m_217043_().m_188500_() * 18.0);
        double target = (double)groundY + base;
        double cap = (double)groundY + capAboveGround;
        double worldCap = (double)this.dragon.m_9236_().m_151558_() - 10.0;
        return Math.min(Math.min(target, cap), worldCap);
    }

    private int findGroundInCave(double x, double currentY, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, currentY, z);
        while (pos.m_123342_() > this.dragon.m_9236_().m_141937_() && !this.dragon.m_9236_().m_8055_((BlockPos)pos).m_280296_() && this.dragon.m_9236_().m_6425_((BlockPos)pos).m_76178_()) {
            pos.m_122184_(0, -1, 0);
        }
        return pos.m_123342_();
    }

    private int findCeilingInCave(double x, double floorY, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, floorY + 2.0, z);
        while (pos.m_123342_() < this.dragon.m_9236_().m_151558_() && !this.dragon.m_9236_().m_8055_((BlockPos)pos).m_280296_()) {
            pos.m_122184_(0, 1, 0);
        }
        return Math.max((int)floorY + 10, pos.m_123342_() - 1);
    }

    private Vec3 getFlightAnchor() {
        LivingEntity owner;
        if (this.isTamedWander() && (owner = this.dragon.m_269323_()) != null) {
            return owner.m_20182_();
        }
        return this.dragon.m_20182_();
    }

    private boolean isTamedWander() {
        return this.dragon.m_21824_() && this.dragon.getCommand() == 2 && this.dragon.m_269323_() != null;
    }

    private boolean isValidFlightTarget(Vec3 target) {
        double distanceToTarget;
        if (target == null) {
            return false;
        }
        BlockHitResult result = this.dragon.m_9236_().m_45547_(new ClipContext(this.dragon.m_146892_(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.dragon));
        if (result.m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        double distanceToHit = result.m_82450_().m_82554_(this.dragon.m_20182_());
        return distanceToHit > (distanceToTarget = target.m_82554_(this.dragon.m_20182_())) * 0.95;
    }

    private int flightDecisionInterval() {
        return 10;
    }

    private int nextDecisionCooldown(int baseInterval) {
        int jitter = Math.max(1, baseInterval / 2);
        return baseInterval + this.dragon.m_217043_().m_188503_(jitter);
    }

    private boolean shouldTakeOff() {
        if (this.isOverDanger()) {
            return true;
        }
        return this.dragon.m_217043_().m_188503_(30) == 0;
    }

    private boolean shouldKeepFlying() {
        if (this.isOverDanger()) {
            return true;
        }
        return this.dragon.m_217043_().m_188503_(3000) != 0;
    }

    private boolean isOverDanger() {
        BlockPos dragonPos = this.dragon.m_20183_();
        boolean foundSolid = false;
        boolean nearFluid = false;
        for (int i = 1; i <= 25; ++i) {
            BlockPos checkPos = dragonPos.m_6625_(i);
            BlockState state = this.dragon.m_9236_().m_8055_(checkPos);
            if (!state.m_60812_((BlockGetter)this.dragon.m_9236_(), checkPos).m_83281_() || state.m_60783_((BlockGetter)this.dragon.m_9236_(), checkPos, Direction.UP)) {
                foundSolid = true;
                break;
            }
            if (i > 10 || this.dragon.m_9236_().m_6425_(checkPos).m_76178_()) continue;
            nearFluid = true;
        }
        if (nearFluid) {
            return true;
        }
        return !foundSolid && dragonPos.m_123342_() < this.dragon.m_9236_().m_141937_() + 20;
    }
}

