/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.ignivorus;

import com.leon.saintsdragons.common.registry.ignivorus.IgnivorusAbilities;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class IgnivorusAirCombatGoal
extends Goal {
    private final Ignivorus dragon;
    private final double biteRange = 16.0;
    private final double fireBreathMinRange = 20.0;
    private final double fireBreathMaxRange = 64.0;
    private static final double HOVER_HEIGHT_OFFSET = 2.0;
    private static final double ENGAGEMENT_DISTANCE = 25.0;
    private int attackCooldown = 0;
    private int repositionCooldown = 0;
    private int breathCooldown = 0;
    private static final int BREATH_COOLDOWN_TICKS = 2400;
    private int shotFromBelowCounter = 0;
    private static final int SHOT_FROM_BELOW_THRESHOLD = 3;
    private long lastDamageTick = 0L;

    public IgnivorusAirCombatGoal(Ignivorus dragon) {
        this.dragon = dragon;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Player player;
        LivingEntity target = this.dragon.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
            return false;
        }
        if (this.dragon.m_20160_() || this.dragon.m_21827_()) {
            return false;
        }
        if (!this.isTargetAirborne(target)) {
            return false;
        }
        if (!(this.dragon.m_29443_() || this.dragon.isHovering() || this.dragon.isTakeoff() || this.dragon.isLanding() || this.canTriggerFlight())) {
            return false;
        }
        return !(this.dragon.m_20280_((Entity)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean m_8045_() {
        Player player;
        LivingEntity target = this.dragon.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
            return false;
        }
        if (this.dragon.m_20160_() || this.dragon.m_21827_()) {
            return false;
        }
        if (this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_FIRE_BREATH) || this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_BITE)) {
            return true;
        }
        if (!this.isTargetAirborne(target)) {
            return false;
        }
        if (this.dragon.isLanding()) {
            return false;
        }
        return !(this.dragon.m_20280_((Entity)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        this.dragon.m_21561_(false);
        this.attackCooldown = 0;
        this.repositionCooldown = 0;
        if (this.dragon.m_29443_() || this.dragon.isHovering()) {
            this.dragon.setFlying(false);
            this.dragon.setTakeoff(false);
            this.dragon.setHovering(false);
        }
    }

    public void m_8056_() {
        this.dragon.m_21561_(true);
        if (!(!this.dragon.m_20096_() || this.dragon.m_29443_() || this.dragon.isHovering() || this.dragon.isTakeoff() || this.dragon.isLanding())) {
            this.dragon.setFlying(true);
            this.dragon.setTakeoff(true);
            this.dragon.setLanding(false);
            this.dragon.setHovering(false);
        } else if (this.dragon.m_29443_() || this.dragon.isHovering()) {
            this.dragon.setTakeoff(false);
            this.dragon.setFlying(true);
            this.dragon.setLanding(false);
        }
    }

    public void m_8037_() {
        LivingEntity target;
        if (this.dragon.isTakeoff() && !this.dragon.m_20096_()) {
            this.dragon.setTakeoff(false);
            this.dragon.setFlying(true);
            this.dragon.setHovering(false);
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.breathCooldown > 0) {
            --this.breathCooldown;
        }
        if (this.repositionCooldown > 0) {
            --this.repositionCooldown;
        }
        if ((target = this.dragon.m_5448_()) == null || !target.m_6084_()) {
            return;
        }
        this.dragon.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        this.checkEmergencyLanding(target);
        double distance = this.dragon.m_20270_((Entity)target);
        boolean hasLineOfSight = this.dragon.m_21574_().m_148306_((Entity)target);
        if (distance <= 16.0 && hasLineOfSight) {
            if (!this.isCurrentlyAttacking()) {
                this.tryAttack(target, distance);
            }
            this.maintainCombatPosition(target);
        } else if (distance >= 20.0 && distance <= 64.0 && hasLineOfSight && this.breathCooldown <= 0) {
            if (!this.isCurrentlyAttacking()) {
                this.tryAttack(target, distance);
            }
            if (this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_FIRE_BREATH)) {
                this.dragon.m_21566_().m_6849_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_(), 0.5);
            } else {
                this.maintainCombatPosition(target);
            }
        } else {
            this.chaseTarget(target);
        }
    }

    private boolean isCurrentlyAttacking() {
        return this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_BITE) || this.dragon.isAbilityActive(IgnivorusAbilities.IGNIVORUS_FIRE_BREATH);
    }

    private void tryAttack(LivingEntity target, double distance) {
        if (this.attackCooldown > 0 || this.isCurrentlyAttacking()) {
            return;
        }
        if (!this.dragon.m_21574_().m_148306_((Entity)target)) {
            return;
        }
        if (distance <= 16.0) {
            this.dragon.combatManager.tryUseAbility(IgnivorusAbilities.IGNIVORUS_BITE);
            this.attackCooldown = 20;
        } else if (distance >= 20.0 && distance <= 64.0 && this.breathCooldown <= 0) {
            this.dragon.combatManager.tryUseAbility(IgnivorusAbilities.IGNIVORUS_FIRE_BREATH);
            this.attackCooldown = 60;
            this.breathCooldown = 2400;
        }
    }

    private void chaseTarget(LivingEntity target) {
        double targetY = target.m_20186_() + (double)target.m_20206_() + 2.0;
        Vec3 toTarget = new Vec3(target.m_20185_() - this.dragon.m_20185_(), targetY - this.dragon.m_20186_(), target.m_20189_() - this.dragon.m_20189_()).m_82541_();
        Vec3 targetVelocity = target.m_20184_();
        double targetX = target.m_20185_() + targetVelocity.f_82479_ * 5.0;
        double targetZ = target.m_20189_() + targetVelocity.f_82481_ * 5.0;
        double verticalOffset = Math.sin((double)this.dragon.f_19797_ * 0.15) * 0.5;
        this.dragon.m_21566_().m_6849_(targetX, targetY + verticalOffset, targetZ, 3.5);
    }

    private void maintainCombatPosition(LivingEntity target) {
        if (this.repositionCooldown > 0) {
            return;
        }
        double distance = this.dragon.m_20270_((Entity)target);
        double targetY = target.m_20186_() + (double)target.m_20206_() + 2.0;
        Vec3 targetLook = target.m_20154_();
        double angle = (double)this.dragon.f_19797_ * 0.05 % (Math.PI * 2);
        double offsetX = Math.cos(angle) * 25.0;
        double offsetZ = Math.sin(angle) * 25.0;
        double posX = target.m_20185_() + offsetX;
        double posZ = target.m_20189_() + offsetZ;
        double verticalOffset = Math.sin((double)this.dragon.f_19797_ * 0.1) * 1.0;
        this.dragon.m_21566_().m_6849_(posX, targetY + verticalOffset, posZ, 1.0);
        this.repositionCooldown = 20;
    }

    private boolean isTargetAirborne(LivingEntity target) {
        if (target.m_20096_()) {
            return false;
        }
        if (target.m_20159_() && target.m_20202_() != null) {
            return true;
        }
        double groundY = this.dragon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, target.m_20183_()).m_123342_();
        return target.m_20186_() - groundY > 8.0;
    }

    private void checkEmergencyLanding(LivingEntity target) {
        long currentTick = this.dragon.m_9236_().m_46467_();
        if (this.dragon.f_20916_ > 0 && currentTick != this.lastDamageTick) {
            this.lastDamageTick = currentTick;
            if (target.m_20186_() < this.dragon.m_20186_() - 5.0) {
                ++this.shotFromBelowCounter;
                if (this.shotFromBelowCounter >= 3) {
                    this.triggerEmergencyLanding();
                }
            }
        }
        if (currentTick - this.lastDamageTick > 100L) {
            this.shotFromBelowCounter = 0;
        }
    }

    private void triggerEmergencyLanding() {
        this.dragon.setLanding(true);
        this.dragon.setFlying(false);
        this.dragon.setHovering(true);
        this.shotFromBelowCounter = 0;
    }

    private double getMaxAggroDistanceSqr() {
        double followRange = this.dragon.m_21133_(Attributes.f_22277_);
        if (followRange <= 0.0) {
            followRange = 64.0;
        }
        return followRange * followRange;
    }

    private boolean canTriggerFlight() {
        return !this.dragon.m_21827_() && !this.dragon.m_6162_() && (this.dragon.m_20096_() || this.dragon.m_20069_()) && this.dragon.m_20197_().isEmpty() && this.dragon.m_6688_() == null && this.dragon.getActiveAbility() == null;
    }
}

