/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.cindervane;

import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class CindervaneFollowOwnerGoal
extends Goal {
    private final Cindervane amphithere;
    private static final double START_FOLLOW_DIST = 8.8;
    private static final double STOP_FOLLOW_DIST = 8.0;
    private static final double TELEPORT_DIST = 500.0;
    private static final double RUN_DIST = 10.0;
    private static final double FLIGHT_TRIGGER_DIST = 24.0;
    private static final double FLIGHT_HEIGHT_DIFF = 6.0;
    private static final double LANDING_DISTANCE = 10.0;
    private static final double HOVER_HEIGHT = 2.5;
    private int pathRecalcCooldown;
    private double lastOwnerX = Double.NaN;
    private double lastOwnerY = Double.NaN;
    private double lastOwnerZ = Double.NaN;

    public CindervaneFollowOwnerGoal(Cindervane dragon) {
        this.amphithere = dragon;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.amphithere.m_21824_() || this.amphithere.m_21827_()) {
            return false;
        }
        if (this.amphithere.m_20160_() || this.amphithere.m_20159_()) {
            return false;
        }
        if (this.amphithere.isSittingDownAnimation()) {
            return false;
        }
        if (this.amphithere.getCommand() == 1) {
            return false;
        }
        if (this.amphithere.m_5448_() != null && this.amphithere.m_5448_().m_6084_()) {
            return false;
        }
        LivingEntity owner = this.amphithere.m_269323_();
        if (owner == null || !owner.m_6084_()) {
            return false;
        }
        if (owner.m_9236_() != this.amphithere.m_9236_()) {
            return false;
        }
        double distSq = this.amphithere.m_20280_((Entity)owner);
        return distSq > 77.44000000000001;
    }

    public boolean m_8045_() {
        LivingEntity owner = this.amphithere.m_269323_();
        if (owner == null || !owner.m_6084_()) {
            return false;
        }
        if (this.amphithere.m_21827_() || this.amphithere.isSittingDownAnimation() || this.amphithere.getCommand() == 1) {
            return false;
        }
        if (this.amphithere.m_20160_() || this.amphithere.m_20159_()) {
            return false;
        }
        if (this.amphithere.m_5448_() != null && this.amphithere.m_5448_().m_6084_()) {
            return false;
        }
        if (owner.m_9236_() != this.amphithere.m_9236_()) {
            return false;
        }
        double distSq = this.amphithere.m_20280_((Entity)owner);
        return distSq > 64.0;
    }

    public void m_8056_() {
        this.resetPathTracking();
    }

    public void m_8041_() {
        this.amphithere.setRunning(false);
        this.amphithere.m_21573_().m_26573_();
        this.amphithere.setGroundMoveStateFromAI(0);
        this.resetPathTracking();
    }

    public void m_8037_() {
        LivingEntity owner = this.amphithere.m_269323_();
        if (owner == null) {
            return;
        }
        if (this.amphithere.m_20160_() || this.amphithere.m_20159_()) {
            this.amphithere.m_21573_().m_26573_();
            this.amphithere.setRunning(false);
            this.amphithere.setGroundMoveStateFromAI(0);
            this.resetPathTracking();
            return;
        }
        double distance = this.amphithere.m_20270_((Entity)owner);
        if (distance > 500.0) {
            this.amphithere.m_6021_(owner.m_20185_(), owner.m_20186_() + 2.0, owner.m_20189_());
            this.amphithere.setFlying(true);
            this.amphithere.setTakeoff(false);
            this.amphithere.setLanding(false);
            this.amphithere.setHovering(false);
            this.resetPathTracking();
            return;
        }
        this.amphithere.m_21563_().m_24960_((Entity)owner, 10.0f, 10.0f);
        boolean shouldFly = this.shouldTriggerFlight(owner, distance);
        if (shouldFly && !this.amphithere.m_29443_()) {
            this.amphithere.setFlying(true);
            this.amphithere.setTakeoff(true);
            this.amphithere.setLanding(false);
            this.amphithere.setHovering(false);
            this.resetPathTracking();
        } else if (this.amphithere.m_29443_() && distance < 12.0) {
            this.amphithere.setLanding(true);
            this.amphithere.setFlying(false);
            this.amphithere.setHovering(false);
            this.amphithere.setTakeoff(false);
            this.pathRecalcCooldown = 0;
        }
        if (this.amphithere.m_29443_()) {
            this.handleFlightFollowing(owner);
        } else {
            this.handleGroundFollowing(owner, distance);
        }
    }

    private void handleFlightFollowing(LivingEntity owner) {
        double targetZ;
        double targetY = owner.m_20186_() + (double)owner.m_20206_() + 2.5;
        Vec3 ownerLook = owner.m_20154_();
        double offsetX = -ownerLook.f_82479_ * 2.5;
        double offsetZ = -ownerLook.f_82481_ * 2.5;
        double verticalOffset = Math.sin((double)this.amphithere.f_19797_ * 0.2) * 0.25;
        double targetX = owner.m_20185_() + offsetX;
        double distanceToTargetSq = this.amphithere.m_20275_(targetX, targetY, targetZ = owner.m_20189_() + offsetZ);
        if (distanceToTargetSq > 1.0) {
            this.amphithere.m_21566_().m_6849_(targetX, targetY + verticalOffset, targetZ, (double)this.amphithere.getFlightSpeed());
        } else {
            this.amphithere.m_21573_().m_26573_();
        }
    }

    private void handleGroundFollowing(LivingEntity owner, double distance) {
        if (distance <= 8.0) {
            if (this.amphithere.getGroundMoveState() > 0) {
                this.amphithere.m_21573_().m_26573_();
                this.amphithere.setRunning(false);
                this.amphithere.setGroundMoveStateFromAI(0);
            }
            this.pathRecalcCooldown = 0;
            return;
        }
        boolean shouldRun = distance > 10.0;
        this.amphithere.setRunning(shouldRun);
        int moveState = shouldRun ? 2 : 1;
        this.amphithere.setGroundMoveStateFromAI(moveState);
        double baseSpeed = shouldRun ? 1.1 : 0.7;
        double speed = baseSpeed * (1.0 + distance / 40.0);
        speed = Math.min(speed, shouldRun ? 1.6 : 1.0);
        this.updateGroundPath(owner, speed, distance, shouldRun);
        if (this.amphithere.m_21573_().m_26577_()) {
            this.amphithere.m_21569_().m_24901_();
            this.amphithere.m_21573_().m_26573_();
            this.pathRecalcCooldown = 0;
        }
    }

    private boolean shouldTriggerFlight(LivingEntity owner, double distance) {
        if (this.amphithere.m_29443_()) {
            return !(distance < 10.0) || !(owner.m_20186_() - this.amphithere.m_20186_() < 6.0);
        }
        if (this.amphithere.isHovering() || !this.canTriggerFlight()) {
            return false;
        }
        if (distance < 12.0) {
            return false;
        }
        boolean farAway = distance > 24.0;
        boolean ownerAbove = owner.m_20186_() - this.amphithere.m_20186_() > 6.0;
        return farAway || ownerAbove;
    }

    private boolean canTriggerFlight() {
        return !this.amphithere.m_21827_() && !this.amphithere.m_6162_() && (this.amphithere.m_20096_() || this.amphithere.m_20069_()) && this.amphithere.m_20197_().isEmpty() && this.amphithere.m_6688_() == null && !this.amphithere.m_20159_();
    }

    private void updateGroundPath(LivingEntity owner, double speed, double distance, boolean running) {
        boolean navIdle;
        if (this.pathRecalcCooldown > 0) {
            --this.pathRecalcCooldown;
        }
        boolean ownerMoved = this.ownerMovedSignificantly(owner);
        boolean bl = navIdle = this.amphithere.m_21573_().m_26571_() || !this.amphithere.m_21573_().m_26572_();
        if (navIdle || ownerMoved || this.pathRecalcCooldown <= 0) {
            if (!this.amphithere.m_21573_().m_5624_((Entity)owner, speed)) {
                this.amphithere.m_21573_().m_26519_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), speed);
            }
            this.rememberOwnerPosition(owner);
            this.pathRecalcCooldown = this.computeRepathCooldown(distance, running);
        }
    }

    private int computeRepathCooldown(double distance, boolean running) {
        int base = (int)Math.ceil(distance * (running ? 0.35 : 0.45));
        return Mth.m_14045_((int)base, (int)(running ? 4 : 6), (int)(running ? 16 : 22));
    }

    private void rememberOwnerPosition(LivingEntity owner) {
        this.lastOwnerX = owner.m_20185_();
        this.lastOwnerY = owner.m_20186_();
        this.lastOwnerZ = owner.m_20189_();
    }

    private boolean ownerMovedSignificantly(LivingEntity owner) {
        double dz;
        double dy;
        if (Double.isNaN(this.lastOwnerX)) {
            return true;
        }
        double dx = owner.m_20185_() - this.lastOwnerX;
        return dx * dx + (dy = owner.m_20186_() - this.lastOwnerY) * dy + (dz = owner.m_20189_() - this.lastOwnerZ) * dz > 1.2;
    }

    private void resetPathTracking() {
        this.pathRecalcCooldown = 0;
        this.lastOwnerX = Double.NaN;
        this.lastOwnerY = Double.NaN;
        this.lastOwnerZ = Double.NaN;
    }
}

