/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.cindervane;

import com.leon.saintsdragons.common.registry.cindervane.CindervaneAbilities;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;

public class CindervaneCombatGoal
extends Goal {
    private final Cindervane amphithere;
    private final double attackRange = 4.5;
    private final double fireBodyActivationRange = 8.0;
    private final double chaseSpeed = 1.2;
    private int attackCooldown = 0;
    private int fireBodyCheckCooldown = 0;
    private int pathRecalcCooldown = 0;
    private double lastTargetX;
    private double lastTargetY;
    private double lastTargetZ;

    public CindervaneCombatGoal(Cindervane amphithere) {
        this.amphithere = amphithere;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        LivingEntity target = this.amphithere.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.amphithere.m_20160_() || this.amphithere.m_21827_()) {
            return false;
        }
        return !(this.amphithere.m_20280_((Entity)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean m_8045_() {
        LivingEntity target = this.amphithere.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.amphithere.m_20160_() || this.amphithere.m_21827_()) {
            return false;
        }
        return !(this.amphithere.m_20280_((Entity)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        this.amphithere.m_21573_().m_26573_();
        this.deactivateFireBodyIfActive();
        this.pathRecalcCooldown = 0;
    }

    public void m_8056_() {
        LivingEntity target = this.amphithere.m_5448_();
        if (target != null) {
            this.amphithere.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.amphithere.m_21573_().m_5624_((Entity)target, 1.2);
            this.rememberTargetPosition(target);
            double distanceSq = this.amphithere.m_20280_((Entity)target);
            if (distanceSq <= this.getAttackReachSqr(target)) {
                this.tryPerformBite(target);
            }
        }
    }

    public void m_8037_() {
        LivingEntity target;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.fireBodyCheckCooldown > 0) {
            --this.fireBodyCheckCooldown;
        }
        if ((target = this.amphithere.m_5448_()) != null) {
            this.amphithere.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double distanceSq = this.amphithere.m_20280_((Entity)target);
            double attackReachSq = this.getAttackReachSqr(target);
            boolean inAttackRange = distanceSq <= attackReachSq;
            boolean hasLineOfSight = this.amphithere.m_21574_().m_148306_((Entity)target);
            if (!inAttackRange || !hasLineOfSight) {
                if (!this.isCurrentlyBiting()) {
                    this.updateChasePath(target);
                }
            } else {
                this.amphithere.m_21573_().m_26573_();
                this.pathRecalcCooldown = 0;
                this.tryPerformBite(target);
            }
            this.handleFireBodyActivation(target);
        } else {
            this.deactivateFireBodyIfActive();
        }
    }

    private boolean isCurrentlyBiting() {
        return this.amphithere.isAbilityActive(CindervaneAbilities.BITE);
    }

    private void tryPerformBite(LivingEntity target) {
        if (this.attackCooldown > 0 || this.isCurrentlyBiting()) {
            return;
        }
        if (!this.amphithere.m_21574_().m_148306_((Entity)target)) {
            return;
        }
        this.amphithere.combatManager.tryUseAbility(CindervaneAbilities.BITE);
        this.attackCooldown = 40;
    }

    private void handleFireBodyActivation(LivingEntity target) {
        if (this.fireBodyCheckCooldown > 0) {
            return;
        }
        if (this.amphithere.m_20160_()) {
            return;
        }
        if (this.amphithere.m_20072_()) {
            return;
        }
        boolean fireBodyActive = this.amphithere.isAbilityActive(CindervaneAbilities.FIRE_BODY);
        double distanceToTarget = this.amphithere.m_20270_((Entity)target);
        if (!fireBodyActive && distanceToTarget < 8.0) {
            this.amphithere.combatManager.tryUseAbility(CindervaneAbilities.FIRE_BODY);
            this.fireBodyCheckCooldown = 40;
        } else if (fireBodyActive && distanceToTarget > 12.0) {
            this.amphithere.forceEndAbility(CindervaneAbilities.FIRE_BODY);
            this.fireBodyCheckCooldown = 40;
        }
    }

    private void deactivateFireBodyIfActive() {
        if (this.amphithere.m_20160_()) {
            return;
        }
        if (this.amphithere.isAbilityActive(CindervaneAbilities.FIRE_BODY)) {
            this.amphithere.forceEndAbility(CindervaneAbilities.FIRE_BODY);
        }
    }

    private double getAttackReachSqr(LivingEntity target) {
        double combinedRadii = (double)(this.amphithere.m_20205_() + target.m_20205_()) * 0.5;
        double reach = this.attackRange + combinedRadii;
        return reach * reach;
    }

    private double getMaxAggroDistanceSqr() {
        double followRange = this.amphithere.m_21133_(Attributes.f_22277_);
        if (followRange <= 0.0) {
            followRange = 16.0;
        }
        return followRange * followRange;
    }

    private void updateChasePath(LivingEntity target) {
        if (--this.pathRecalcCooldown <= 0 || this.targetMovedSignificantly(target)) {
            this.rememberTargetPosition(target);
            double distance = this.amphithere.m_20270_((Entity)target);
            this.pathRecalcCooldown = Mth.m_14045_((int)((int)(distance * 0.6)), (int)5, (int)20);
            this.amphithere.m_21573_().m_5624_((Entity)target, 1.2);
        }
    }

    private void rememberTargetPosition(LivingEntity target) {
        this.lastTargetX = target.m_20185_();
        this.lastTargetY = target.m_20186_();
        this.lastTargetZ = target.m_20189_();
    }

    private boolean targetMovedSignificantly(LivingEntity target) {
        double dz;
        double dy;
        double dx = target.m_20185_() - this.lastTargetX;
        return dx * dx + (dy = target.m_20186_() - this.lastTargetY) * dy + (dz = target.m_20189_() - this.lastTargetZ) * dz > 4.0;
    }
}

