/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.base;

import com.leon.saintsdragons.server.entity.interfaces.DragonFlightCapable;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class DragonWaterEscapeGoal
extends Goal {
    private final Mob mob;
    private final boolean canFly;
    private final DragonFlightCapable flyingDragon;
    private Vec3 escapeTarget;
    private int recheckCooldown;

    public DragonWaterEscapeGoal(DragonFlightCapable dragon) {
        this.mob = (Mob)dragon;
        this.canFly = true;
        this.flyingDragon = dragon;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public DragonWaterEscapeGoal(Mob mob) {
        this.mob = mob;
        this.canFly = false;
        this.flyingDragon = null;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        TamableAnimal tameable;
        if (!this.mob.m_20069_()) {
            return false;
        }
        if (this.canFly && this.flyingDragon.isFlying()) {
            return false;
        }
        if (this.mob.m_20160_()) {
            return false;
        }
        Mob mob = this.mob;
        if (mob instanceof TamableAnimal && (tameable = (TamableAnimal)mob).m_21827_()) {
            return false;
        }
        if (this.recheckCooldown > 0) {
            --this.recheckCooldown;
            return this.escapeTarget != null;
        }
        this.escapeTarget = this.findNearestShore();
        this.recheckCooldown = 40;
        return this.escapeTarget != null;
    }

    public boolean m_8045_() {
        if (!this.mob.m_20069_()) {
            return false;
        }
        if (this.escapeTarget == null) {
            return false;
        }
        return this.mob.m_20238_(this.escapeTarget) > 4.0;
    }

    public void m_8056_() {
        if (this.canFly && this.flyingDragon != null) {
            this.flyingDragon.setFlying(true);
            this.flyingDragon.setTakeoff(true);
            this.flyingDragon.setLanding(false);
        } else if (this.escapeTarget != null) {
            this.mob.m_21573_().m_26519_(this.escapeTarget.f_82479_, this.escapeTarget.f_82480_, this.escapeTarget.f_82481_, 1.5);
        }
    }

    public void m_8037_() {
        if (this.escapeTarget == null) {
            return;
        }
        if (this.canFly && this.flyingDragon != null) {
            this.mob.m_21566_().m_6849_(this.escapeTarget.f_82479_, this.escapeTarget.f_82480_, this.escapeTarget.f_82481_, (double)this.flyingDragon.getFlightSpeed() * 1.5);
        } else if (this.mob.m_21573_().m_26571_()) {
            this.mob.m_21573_().m_26519_(this.escapeTarget.f_82479_, this.escapeTarget.f_82480_, this.escapeTarget.f_82481_, 1.5);
        }
    }

    public void m_8041_() {
        this.escapeTarget = null;
        this.recheckCooldown = 0;
        if (!this.canFly) {
            this.mob.m_21573_().m_26573_();
        }
    }

    private Vec3 findNearestShore() {
        BlockPos start = this.mob.m_20183_();
        int maxRadius = this.canFly ? 32 : 48;
        for (int radius = 4; radius <= maxRadius; radius += 4) {
            for (int angle = 0; angle < 360; angle += 15) {
                double rad = Math.toRadians(angle);
                int x = start.m_123341_() + (int)(Math.cos(rad) * (double)radius);
                int z = start.m_123343_() + (int)(Math.sin(rad) * (double)radius);
                BlockPos checkPos = new BlockPos(x, start.m_123342_(), z);
                if (!this.mob.m_9236_().m_6425_(checkPos).m_76178_()) continue;
                int groundY = this.mob.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
                BlockPos groundPos = new BlockPos(x, groundY, z);
                if (!this.mob.m_9236_().m_8055_(groundPos).m_280296_() && !this.mob.m_9236_().m_8055_(groundPos.m_7495_()).m_280296_()) continue;
                if (this.canFly) {
                    return new Vec3((double)x + 0.5, (double)(groundY + 2), (double)z + 0.5);
                }
                return new Vec3((double)x + 0.5, (double)groundY, (double)z + 0.5);
            }
        }
        if (this.canFly) {
            return this.mob.m_20182_().m_82520_(0.0, 10.0, 0.0);
        }
        double angle = this.mob.m_217043_().m_188500_() * Math.PI * 2.0;
        double distance = 16.0;
        return this.mob.m_20182_().m_82520_(Math.cos(angle) * distance, 0.0, Math.sin(angle) * distance);
    }
}

