/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.forge.platform;

import com.leon.saintsdragons.platform.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public final class ForgeRegistryHelper
implements RegistryHelper {
    @Override
    public <T> RegistryHelper.RegistryWrapper<T> create(ResourceKey<? extends Registry<T>> registryKey, Supplier<Registry<T>> backingRegistry, String modId) {
        DeferredRegister deferredRegister = DeferredRegister.create(registryKey, (String)modId);
        return new Wrapper(deferredRegister);
    }

    private static final class Wrapper<T>
    implements RegistryHelper.RegistryWrapper<T> {
        private final DeferredRegister<T> deferredRegister;
        private final List<RegistryObject<? extends T>> entries = new ArrayList<RegistryObject<? extends T>>();

        private Wrapper(DeferredRegister<T> deferredRegister) {
            this.deferredRegister = deferredRegister;
        }

        @Override
        public <I extends T> Supplier<I> register(String name, Supplier<I> supplier) {
            RegistryObject registryObject = this.deferredRegister.register(name, supplier);
            this.entries.add(registryObject);
            return () -> ((RegistryObject)registryObject).get();
        }

        @Override
        public void register() {
            this.deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
        }
    }
}

