/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.forge.platform;

import com.leon.saintsdragons.forge.platform.ForgeConfigHelper;
import com.leon.saintsdragons.forge.platform.ForgeNetworkHelper;
import com.leon.saintsdragons.forge.platform.ForgeRegistryHelper;
import com.leon.saintsdragons.platform.ConfigHelper;
import com.leon.saintsdragons.platform.NetworkHelper;
import com.leon.saintsdragons.platform.PlatformHelper;
import com.leon.saintsdragons.platform.RegistryHelper;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;

public final class ForgePlatformHelper
implements PlatformHelper {
    private ForgeRegistryHelper registryHelper;
    private ForgeNetworkHelper networkHelper;
    private ForgeConfigHelper configHelper;

    @Override
    public RegistryHelper getRegistryHelper() {
        if (this.registryHelper == null) {
            this.registryHelper = new ForgeRegistryHelper();
        }
        return this.registryHelper;
    }

    @Override
    public NetworkHelper getNetworkHelper() {
        if (this.networkHelper == null) {
            this.networkHelper = new ForgeNetworkHelper();
        }
        return this.networkHelper;
    }

    @Override
    public ConfigHelper getConfigHelper() {
        if (this.configHelper == null) {
            this.configHelper = new ForgeConfigHelper();
        }
        return this.configHelper;
    }

    @Override
    public void runOnClient(Runnable runnable) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> runnable.run());
    }

    @Override
    public <T> T callOnClient(Supplier<T> supplier) {
        return (T)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ForgePlatformHelper.lambda$callOnClient$2((Supplier)supplier));
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public Item createSpawnEgg(Supplier<? extends EntityType<? extends Mob>> entityType, int primaryColor, int secondaryColor, Item.Properties properties) {
        return new ForgeSpawnEggItem(entityType, primaryColor, secondaryColor, properties);
    }

    @Override
    public SimpleParticleType createSimpleParticle(boolean overrideLimiter) {
        return new SimpleParticleType(overrideLimiter);
    }

    @Override
    public Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    private static /* synthetic */ Object lambda$callOnClient$2(Supplier supplier) throws Exception {
        return supplier.get();
    }
}

