/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.forge.platform;

import com.leon.saintsdragons.platform.NetworkHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public final class ForgeNetworkHelper
implements NetworkHelper {
    private static final String PROTOCOL_VERSION = "1";
    private SimpleChannel channel;
    private final AtomicInteger nextId = new AtomicInteger();

    private SimpleChannel getChannel() {
        if (this.channel == null) {
            this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("saintsdragons", "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        }
        return this.channel;
    }

    @Override
    public <T> void registerServerbound(Class<T> type, ResourceLocation id, NetworkHelper.PacketEncoder<T> encoder, NetworkHelper.PacketDecoder<T> decoder, NetworkHelper.ServerboundHandler<T> handler) {
        this.getChannel().messageBuilder(type, this.nextId.getAndIncrement()).encoder(encoder::encode).decoder(decoder::decode).consumerMainThread((message, contextSupplier) -> {
            ServerPlayer sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (sender != null) {
                handler.handle(message, sender);
            }
        }).add();
    }

    @Override
    public <T> void registerClientbound(Class<T> type, ResourceLocation id, NetworkHelper.PacketEncoder<T> encoder, NetworkHelper.PacketDecoder<T> decoder, NetworkHelper.ClientboundHandler<T> handler) {
        this.getChannel().messageBuilder(type, this.nextId.getAndIncrement()).encoder(encoder::encode).decoder(decoder::decode).consumerMainThread((message, contextSupplier) -> handler.handle(message)).add();
    }

    @Override
    public void sendToServer(Object message) {
        this.getChannel().sendToServer(message);
    }

    @Override
    public void sendToPlayer(ServerPlayer player, Object message) {
        this.getChannel().send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    @Override
    public void sendToTracking(Entity entity, Object message) {
        this.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    @Override
    public void sendToDimension(Level level, Object message) {
        this.getChannel().send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), message);
    }
}

