/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.network;

import com.leon.saintsdragons.common.network.MessageDragonAllyDelta;
import com.leon.saintsdragons.common.network.NetworkHandler;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.handler.DragonAllyManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MessageDragonAllyManagement {
    private final int dragonId;
    private final Action action;
    private final String username;

    public MessageDragonAllyManagement(int dragonId, Action action, String username) {
        this.dragonId = dragonId;
        this.action = action;
        this.username = username;
    }

    private MessageDragonAllyManagement(FriendlyByteBuf buffer) {
        this.dragonId = buffer.readInt();
        this.action = (Action)buffer.m_130066_(Action.class);
        this.username = buffer.m_130136_(16);
    }

    public static void encode(MessageDragonAllyManagement message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.dragonId);
        buffer.m_130068_((Enum)message.action);
        buffer.m_130072_(message.username, 16);
    }

    public static MessageDragonAllyManagement decode(FriendlyByteBuf buffer) {
        return new MessageDragonAllyManagement(buffer);
    }

    public static void handle(MessageDragonAllyManagement message, ServerPlayer player) {
        MutableComponent resultMessage;
        if (player == null) {
            return;
        }
        Entity entity = player.m_9236_().m_6815_(message.dragonId);
        if (!(entity instanceof DragonEntity)) {
            player.m_213846_((Component)Component.m_237115_((String)"saintsdragons.message.dragon_not_found"));
            return;
        }
        DragonEntity dragon = (DragonEntity)entity;
        if (!dragon.m_21824_() || !dragon.m_21830_((LivingEntity)player)) {
            player.m_213846_((Component)Component.m_237115_((String)"saintsdragons.message.not_dragon_owner"));
            return;
        }
        DragonAllyManager allyManager = dragon.allyManager;
        DragonAllyManager.AllyResult result = switch (message.action.ordinal()) {
            case 0 -> allyManager.addAlly(message.username);
            case 1 -> allyManager.removeAlly(message.username);
            default -> DragonAllyManager.AllyResult.INVALID_USERNAME;
        };
        if (result == DragonAllyManager.AllyResult.EASTER_EGG) {
            resultMessage = switch (message.username.toLowerCase()) {
                case "notch" -> Component.m_237115_((String)"saintsdragons.message.easter_egg.notch");
                case "jeb_" -> Component.m_237115_((String)"saintsdragons.message.easter_egg.jeb_");
                case "dinnerbone" -> Component.m_237115_((String)"saintsdragons.message.easter_egg.dinnerbone");
                case "grumm" -> Component.m_237115_((String)"saintsdragons.message.easter_egg.grumm");
                case "herobrine" -> Component.m_237115_((String)"saintsdragons.message.easter_egg.herobrine");
                default -> Component.m_237115_((String)"saintsdragons.message.ally.easter_egg");
            };
        } else {
            resultMessage = Component.m_237110_((String)("saintsdragons.message.ally." + result.name().toLowerCase()), (Object[])new Object[]{message.username});
        }
        player.m_213846_((Component)resultMessage);
        if (result == DragonAllyManager.AllyResult.SUCCESS) {
            boolean isAdd = message.action == Action.ADD;
            NetworkHandler.sendToPlayer(player, new MessageDragonAllyDelta(dragon.m_19879_(), message.username, isAdd));
        }
    }

    public static enum Action {
        ADD,
        REMOVE;

    }
}

