/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.config.dragon;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.common.config.dragon.DragonAbilityOverride;
import com.leon.saintsdragons.common.config.dragon.DragonAttributeConfig;
import com.leon.saintsdragons.platform.Services;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public final class DragonAttributeConfigLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final ResourceLocation CINDERVANE_ID = SaintsDragonsCommon.rl("cindervane");
    public static final ResourceLocation RAEVYX_ID = SaintsDragonsCommon.rl("raevyx");
    public static final ResourceLocation NULLJAW_ID = SaintsDragonsCommon.rl("nulljaw");
    public static final ResourceLocation IGNIVORUS_ID = SaintsDragonsCommon.rl("ignivorus");
    private static final DragonAttributeConfigLoader INSTANCE = new DragonAttributeConfigLoader();
    private final Map<ResourceLocation, DragonAttributeConfig> defaults;
    private final Path configDirectory = Services.PLATFORM.getConfigDirectory().resolve("saintsdragons").resolve("dragon_attributes");
    private volatile Map<ResourceLocation, DragonAttributeConfig> configs;

    private DragonAttributeConfigLoader() {
        super(GSON, "dragon_attributes");
        HashMap<ResourceLocation, DragonAttributeConfig> base = new HashMap<ResourceLocation, DragonAttributeConfig>();
        base.put(CINDERVANE_ID, DragonAttributeConfigLoader.cindervaneDefaults());
        base.put(RAEVYX_ID, DragonAttributeConfigLoader.raevyxDefaults());
        base.put(NULLJAW_ID, DragonAttributeConfigLoader.nulljawDefaults());
        base.put(IGNIVORUS_ID, DragonAttributeConfigLoader.ignivorusDefaults());
        this.defaults = ImmutableMap.copyOf(base);
        this.configs = this.defaults;
    }

    private static DragonAttributeConfig cindervaneDefaults() {
        return new DragonAttributeConfig(80.0, 4.0, 0.45, 0.6, Map.of("bite", DragonAbilityOverride.ofDamage(12.0), "magma_volley", DragonAbilityOverride.ofDamage(20.0)), Map.of("taming_chance_base", 4.0, "taming_chance_hearty", 2.0), Map.of());
    }

    private static DragonAttributeConfig raevyxDefaults() {
        return new DragonAttributeConfig(180.0, 8.0, 0.25, 1.0, Map.of("bite", DragonAbilityOverride.ofDamage(15.0), "lightning_beam", DragonAbilityOverride.ofDamage(35.0), "horn_gore", DragonAbilityOverride.ofDamage(15.0)), Map.of("taming_chance_base", 5.0, "taming_chance_hearty", 3.0), Map.of("legacy_taming", false));
    }

    private static DragonAttributeConfig nulljawDefaults() {
        return new DragonAttributeConfig(250.0, 8.0, 0.28, 0.0, Map.of("bite_phase1", DragonAbilityOverride.ofDamage(40.0), "bite_phase2", DragonAbilityOverride.ofDamage(50.0), "horn_gore_phase1", DragonAbilityOverride.ofDamage(16.0), "horn_gore_phase2", DragonAbilityOverride.ofDamage(20.8)), Map.of("swim_speed", 1.45, "taming_chance", 6.0), Map.of("legacy_taming", false));
    }

    private static DragonAttributeConfig ignivorusDefaults() {
        return new DragonAttributeConfig(300.0, 4.0, 0.3, 0.4, Map.of("bite", DragonAbilityOverride.ofDamage(50.0), "body_slam", DragonAbilityOverride.ofDamage(40.0), "fire_breath", DragonAbilityOverride.ofDamage(80.0), "ultimate", DragonAbilityOverride.ofDamage(200.0)), Map.of("ultimate_penalty_health", 50.0, "taming_chance_base", 7.0, "taming_chance_hearty", 4.0), Map.of("legacy_taming", false));
    }

    public static DragonAttributeConfigLoader getInstance() {
        return INSTANCE;
    }

    public static void bootstrap() {
        DragonAttributeConfigLoader.getInstance();
    }

    public DragonAttributeConfig getConfig(ResourceLocation id) {
        DragonAttributeConfig config = this.configs.get(id);
        if (config != null) {
            return config;
        }
        DragonAttributeConfig fallback = this.defaults.get(id);
        return fallback != null ? fallback : DragonAttributeConfig.EMPTY;
    }

    public DragonAttributeConfig getDefaultConfig(ResourceLocation id) {
        return this.defaults.getOrDefault(id, DragonAttributeConfig.EMPTY);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap<ResourceLocation, DragonAttributeConfig> merged = new HashMap<ResourceLocation, DragonAttributeConfig>(this.defaults);
        HashMap<ResourceLocation, JsonObject> rawJson = new HashMap<ResourceLocation, JsonObject>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonMap.entrySet()) {
            try {
                ResourceLocation id = entry.getKey();
                DragonAttributeConfig fallback = merged.getOrDefault(id, DragonAttributeConfig.EMPTY);
                JsonObject data = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)id.toString());
                rawJson.put(id, data);
                DragonAttributeConfig parsed = DragonAttributeConfig.merge(data, fallback);
                merged.put(id, parsed);
            }
            catch (Exception exception) {
                SaintsDragonsCommon.LOGGER.error("Failed to parse dragon attribute config {}", (Object)entry.getKey(), (Object)exception);
            }
        }
        this.applyConfigOverrides(merged, rawJson);
        this.configs = ImmutableMap.copyOf(merged);
        SaintsDragonsCommon.LOGGER.info("Loaded {} dragon attribute configuration(s)", (Object)this.configs.size());
    }

    private void applyConfigOverrides(Map<ResourceLocation, DragonAttributeConfig> merged, Map<ResourceLocation, JsonObject> rawJson) {
        try {
            Files.createDirectories(this.configDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            SaintsDragonsCommon.LOGGER.warn("Failed to create dragon attribute config directory {}", (Object)this.configDirectory, (Object)e);
        }
        for (Map.Entry<ResourceLocation, DragonAttributeConfig> entry : merged.entrySet()) {
            JsonObject hints;
            Path path = this.configPath(entry.getKey());
            JsonObject source = rawJson.getOrDefault(entry.getKey(), DragonAttributeConfigLoader.serializeConfig(entry.getKey(), entry.getValue()));
            DragonAttributeConfigLoader.ensureLegacyTamingFlag(entry.getKey(), source);
            if (Files.exists(path, new LinkOption[0])) {
                this.backfillIgnivorusFireBreathDamage(path, entry.getKey(), entry.getValue());
                this.backfillLegacyTaming(path, entry.getKey());
                continue;
            }
            if (!source.has("hints") && (hints = DragonAttributeConfigLoader.defaultHints(entry.getKey())) != null && !hints.entrySet().isEmpty()) {
                source.add("hints", (JsonElement)hints);
            }
            this.writeConfigFile(path, source);
        }
        for (Map.Entry<ResourceLocation, DragonAttributeConfig> entry : merged.entrySet()) {
            DragonAttributeConfig override = this.readOverride(entry.getKey(), entry.getValue());
            merged.put(entry.getKey(), override);
        }
    }

    private DragonAttributeConfig readOverride(ResourceLocation id, DragonAttributeConfig fallback) {
        DragonAttributeConfig dragonAttributeConfig;
        block9: {
            Path path = this.configPath(id);
            if (!Files.exists(path, new LinkOption[0])) {
                return fallback;
            }
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                JsonElement element = JsonParser.parseReader((Reader)reader);
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)id.toString());
                dragonAttributeConfig = DragonAttributeConfig.merge(json, fallback);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SaintsDragonsCommon.LOGGER.error("Failed to read dragon attribute config {} from {}", new Object[]{id, path, e});
                    return fallback;
                }
            }
            ((Reader)reader).close();
        }
        return dragonAttributeConfig;
    }

    private void writeConfigFile(Path path, JsonObject json) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(GSON.toJson((JsonElement)json));
            }
        }
        catch (IOException e) {
            SaintsDragonsCommon.LOGGER.error("Failed to write dragon attribute config {}", (Object)path, (Object)e);
        }
    }

    private Path configPath(ResourceLocation id) {
        return this.configDirectory.resolve(id.m_135815_() + ".json");
    }

    private static JsonObject serializeConfig(ResourceLocation id, DragonAttributeConfig config) {
        JsonObject hints;
        JsonObject json = new JsonObject();
        json.addProperty("max_health", (Number)config.maxHealth());
        json.addProperty("armor", (Number)config.armor());
        json.addProperty("movement_speed", (Number)config.movementSpeed());
        json.addProperty("flying_speed", (Number)config.flyingSpeed());
        if (!config.abilities().isEmpty()) {
            JsonObject abilitiesJson = new JsonObject();
            config.abilities().forEach((key, override) -> {
                JsonObject abilityJson = new JsonObject();
                Double damage = override.damage();
                if (damage != null) {
                    abilityJson.addProperty("damage", (Number)damage);
                }
                abilitiesJson.add(key, (JsonElement)abilityJson);
            });
            json.add("abilities", (JsonElement)abilitiesJson);
        }
        if (!config.extraDoubles().isEmpty()) {
            JsonObject extraJson = new JsonObject();
            config.extraDoubles().forEach((arg_0, arg_1) -> ((JsonObject)extraJson).addProperty(arg_0, arg_1));
            json.add("extra", (JsonElement)extraJson);
        }
        if (!config.extraBooleans().isEmpty() || DragonAttributeConfigLoader.requiresLegacyTamingFlag(id)) {
            JsonObject booleansJson = new JsonObject();
            config.extraBooleans().forEach((arg_0, arg_1) -> ((JsonObject)booleansJson).addProperty(arg_0, arg_1));
            if (DragonAttributeConfigLoader.requiresLegacyTamingFlag(id) && !booleansJson.has("legacy_taming")) {
                booleansJson.addProperty("legacy_taming", Boolean.valueOf(false));
            }
            json.add("extra_booleans", (JsonElement)booleansJson);
        }
        if (!json.has("hints") && (hints = DragonAttributeConfigLoader.defaultHints(id)) != null && !hints.entrySet().isEmpty()) {
            json.add("hints", (JsonElement)hints);
        }
        return json;
    }

    public void overwriteConfig(ResourceLocation id, DragonAttributeConfig config) {
        this.writeConfigFile(this.configPath(id), DragonAttributeConfigLoader.serializeConfig(id, config));
        HashMap<ResourceLocation, DragonAttributeConfig> updated = new HashMap<ResourceLocation, DragonAttributeConfig>(this.configs);
        updated.put(id, config);
        this.configs = ImmutableMap.copyOf(updated);
    }

    private static void ensureLegacyTamingFlag(ResourceLocation id, JsonObject json) {
        JsonObject hints;
        JsonObject booleansJson;
        if (!DragonAttributeConfigLoader.requiresLegacyTamingFlag(id)) {
            return;
        }
        boolean changed = false;
        if (json.has("extra_booleans")) {
            booleansJson = GsonHelper.m_13930_((JsonObject)json, (String)"extra_booleans");
        } else {
            booleansJson = new JsonObject();
            json.add("extra_booleans", (JsonElement)booleansJson);
            changed = true;
        }
        if (!booleansJson.has("legacy_taming")) {
            booleansJson.addProperty("legacy_taming", Boolean.valueOf(false));
            changed = true;
        }
        if (changed && !json.has("hints") && (hints = DragonAttributeConfigLoader.defaultHints(id)) != null && !hints.entrySet().isEmpty()) {
            json.add("hints", (JsonElement)hints);
        }
    }

    private void backfillLegacyTaming(Path path, ResourceLocation id) {
        if (!DragonAttributeConfigLoader.requiresLegacyTamingFlag(id)) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            boolean needsUpdate;
            JsonElement element = JsonParser.parseReader((Reader)reader);
            JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)id.toString());
            boolean bl = needsUpdate = !json.has("extra_booleans") || !GsonHelper.m_13930_((JsonObject)json, (String)"extra_booleans").has("legacy_taming");
            if (needsUpdate) {
                DragonAttributeConfigLoader.ensureLegacyTamingFlag(id, json);
                this.writeConfigFile(path, json);
            }
        }
        catch (Exception e) {
            SaintsDragonsCommon.LOGGER.warn("Failed to backfill legacy_taming flag for {} at {}", new Object[]{id, path, e});
        }
    }

    private void backfillIgnivorusFireBreathDamage(Path path, ResourceLocation id, DragonAttributeConfig mergedConfig) {
        if (!id.equals((Object)IGNIVORUS_ID)) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)id.toString());
            JsonObject abilities = json.has("abilities") ? GsonHelper.m_13930_((JsonObject)json, (String)"abilities") : new JsonObject();
            JsonObject fireBreath = abilities.has("fire_breath") ? GsonHelper.m_13930_((JsonObject)abilities, (String)"fire_breath") : new JsonObject();
            boolean hasDamage = fireBreath.has("damage");
            double current = hasDamage ? GsonHelper.m_144784_((JsonObject)fireBreath, (String)"damage") : Double.NaN;
            double newDefault = mergedConfig.abilityDamage("fire_breath", 80.0);
            if (!hasDamage || current <= 4.0001) {
                fireBreath.addProperty("damage", (Number)newDefault);
                abilities.add("fire_breath", (JsonElement)fireBreath);
                json.add("abilities", (JsonElement)abilities);
                this.writeConfigFile(path, json);
                SaintsDragonsCommon.LOGGER.info("Updated Ignivorus fire_breath damage in {} to {}", (Object)path, (Object)newDefault);
            }
        }
        catch (Exception e) {
            SaintsDragonsCommon.LOGGER.warn("Failed to backfill ignivorus fire_breath damage at {}", (Object)path, (Object)e);
        }
    }

    private static boolean requiresLegacyTamingFlag(ResourceLocation id) {
        return id.equals((Object)NULLJAW_ID) || id.equals((Object)RAEVYX_ID) || id.equals((Object)IGNIVORUS_ID);
    }

    private static JsonObject defaultHints(ResourceLocation id) {
        JsonObject hints = new JsonObject();
        hints.addProperty("taming_chance_base", "Lower is easier: 1 = 100% per feed, 100 = 1% per feed");
        hints.addProperty("taming_chance_hearty", "Lower is easier: 1 = 100% per feed, 100 = 1% per feed");
        hints.addProperty("taming_chance", "Lower is easier: 1 = 100% per attempt, 100 = 1% per attempt");
        hints.addProperty("legacy_taming", "true = simple food taming, false = special mechanics (rodeo/low-health)");
        if (id.equals((Object)NULLJAW_ID)) {
            hints.addProperty("swim_speed", "Min 0.1, Max 5.0");
        } else if (id.equals((Object)IGNIVORUS_ID)) {
            hints.addProperty("ultimate_penalty_health", "Typical 1-500");
        }
        return hints;
    }
}

