/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.config.dragon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.leon.saintsdragons.common.config.dragon.DragonAbilityOverride;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public record DragonAttributeConfig(double maxHealth, double armor, double movementSpeed, double flyingSpeed, Map<String, DragonAbilityOverride> abilities, Map<String, Double> extraDoubles, Map<String, Boolean> extraBooleans) {
    public static final DragonAttributeConfig EMPTY = new DragonAttributeConfig(40.0, 0.0, 0.3, 0.3, Map.of(), Map.of(), Map.of());

    public DragonAttributeConfig(double maxHealth, double armor, double movementSpeed, double flyingSpeed, Map<String, DragonAbilityOverride> abilities, Map<String, Double> extraDoubles, Map<String, Boolean> extraBooleans) {
        this.maxHealth = maxHealth;
        this.armor = armor;
        this.movementSpeed = movementSpeed;
        this.flyingSpeed = flyingSpeed;
        this.abilities = Map.copyOf(abilities);
        this.extraDoubles = Map.copyOf(extraDoubles);
        this.extraBooleans = Map.copyOf(extraBooleans);
    }

    public double abilityDamage(String key, double fallback) {
        DragonAbilityOverride override = this.abilities.get(key);
        return override != null ? override.damageOr(fallback) : fallback;
    }

    public double extraDouble(String key, double fallback) {
        return this.extraDoubles.getOrDefault(key, fallback);
    }

    public boolean extraBoolean(String key, boolean fallback) {
        return this.extraBooleans.getOrDefault(key, fallback);
    }

    public double groundRunSpeed(double fallback) {
        return this.extraDoubles.getOrDefault("run_speed", fallback);
    }

    public double groundWalkSpeed(double fallback) {
        return this.extraDoubles.getOrDefault("walk_speed", fallback);
    }

    public static DragonAttributeConfig merge(JsonObject json, @Nullable DragonAttributeConfig fallback) {
        DragonAttributeConfig base = fallback != null ? fallback : EMPTY;
        double maxHealth = GsonHelper.m_144742_((JsonObject)json, (String)"max_health", (double)base.maxHealth);
        double armor = GsonHelper.m_144742_((JsonObject)json, (String)"armor", (double)base.armor);
        double movementSpeed = GsonHelper.m_144742_((JsonObject)json, (String)"movement_speed", (double)base.movementSpeed);
        double flyingSpeed = GsonHelper.m_144742_((JsonObject)json, (String)"flying_speed", (double)base.flyingSpeed);
        HashMap<String, DragonAbilityOverride> abilityMap = new HashMap<String, DragonAbilityOverride>(base.abilities);
        if (json.has("abilities")) {
            JsonObject abilitiesJson = GsonHelper.m_13930_((JsonObject)json, (String)"abilities");
            for (Object entry : abilitiesJson.entrySet()) {
                JsonObject overrideJson = GsonHelper.m_13918_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                DragonAbilityOverride override = DragonAbilityOverride.merge(overrideJson, (DragonAbilityOverride)abilityMap.get(entry.getKey()));
                abilityMap.put((String)entry.getKey(), override);
            }
        }
        HashMap<String, Double> extra = new HashMap<String, Double>(base.extraDoubles);
        if (json.has("extra")) {
            JsonObject extraJson = GsonHelper.m_13930_((JsonObject)json, (String)"extra");
            for (Map.Entry entry : extraJson.entrySet()) {
                extra.put((String)entry.getKey(), GsonHelper.m_144769_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey())));
            }
        }
        HashMap<String, Boolean> booleans = new HashMap<String, Boolean>(base.extraBooleans);
        if (json.has("extra_booleans")) {
            JsonObject booleansJson = GsonHelper.m_13930_((JsonObject)json, (String)"extra_booleans");
            for (Map.Entry entry : booleansJson.entrySet()) {
                booleans.put((String)entry.getKey(), GsonHelper.m_13877_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey())));
            }
        }
        return new DragonAttributeConfig(maxHealth, armor, movementSpeed, flyingSpeed, abilityMap, extra, booleans);
    }
}

