/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class MeleeModeNotification {
    private static final long DISPLAY_DURATION_MS = 3000L;
    private static final long SLIDE_IN_DURATION_MS = 200L;
    private static final long SLIDE_OUT_DURATION_MS = 250L;
    private static final long TOTAL_DURATION_MS = 3450L;
    private Component message = null;
    private int meleeMode = -1;
    private long showTime = 0L;
    private boolean visible = false;

    public void showNotification(int mode) {
        this.meleeMode = mode;
        this.showTime = System.currentTimeMillis();
        this.visible = true;
        this.message = mode == 0 ? Component.m_237115_((String)"ui.saintsdragons.melee_mode.primary") : (mode == 1 ? Component.m_237115_((String)"ui.saintsdragons.melee_mode.secondary") : Component.m_237113_((String)("Mode " + mode)));
    }

    public void tick() {
        long elapsed;
        if (this.visible && (elapsed = System.currentTimeMillis() - this.showTime) >= 3450L) {
            this.visible = false;
            this.message = null;
        }
    }

    public void render(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        float fadeProgress;
        float slideProgress;
        if (!this.visible || this.message == null) {
            return;
        }
        long elapsed = System.currentTimeMillis() - this.showTime;
        if (elapsed < 0L) {
            elapsed = 0L;
        }
        if (elapsed >= 3450L) {
            this.visible = false;
            this.message = null;
            return;
        }
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.message);
        int padding = 6;
        int boxWidth = textWidth + padding * 2;
        int boxHeight = 14;
        int targetX = screenWidth - boxWidth - 10;
        int y = screenHeight / 2 - 40;
        if (elapsed < 200L) {
            float normalized = (float)elapsed / 200.0f;
            fadeProgress = slideProgress = this.easeOutCubic(normalized);
        } else if (elapsed < 3200L) {
            slideProgress = 1.0f;
            fadeProgress = 1.0f;
        } else {
            long slideOutElapsed = elapsed - 200L - 3000L;
            float normalized = 1.0f - (float)slideOutElapsed / 250.0f;
            normalized = Math.max(0.0f, Math.min(1.0f, normalized));
            fadeProgress = slideProgress = this.easeInCubic(normalized);
        }
        slideProgress = Math.max(0.0f, Math.min(1.0f, slideProgress));
        fadeProgress = Math.max(0.0f, Math.min(1.0f, fadeProgress));
        int slideOffset = (int)((1.0f - slideProgress) * (float)(boxWidth + 20));
        int x = targetX + slideOffset;
        int bgAlpha = Math.round(144.0f * fadeProgress);
        int borderAlpha = Math.round(255.0f * fadeProgress);
        int textAlpha = Math.round(255.0f * fadeProgress);
        int bgColor = bgAlpha << 24 | 0;
        int borderColor = borderAlpha << 24 | 0x555555;
        int textColor = textAlpha << 24 | 0xFFFFFF;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280509_(x, y - 2, x + boxWidth, y + boxHeight - 2, bgColor);
        guiGraphics.m_280509_(x, y - 2, x + boxWidth, y - 1, borderColor);
        guiGraphics.m_280509_(x, y + boxHeight - 3, x + boxWidth, y + boxHeight - 2, borderColor);
        guiGraphics.m_280509_(x, y - 2, x + 1, y + boxHeight - 2, borderColor);
        guiGraphics.m_280509_(x + boxWidth - 1, y - 2, x + boxWidth, y + boxHeight - 2, borderColor);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, this.message, x + padding, y, textColor, false);
        RenderSystem.disableBlend();
    }

    private float easeOutCubic(float t) {
        float f = 1.0f - t;
        return 1.0f - f * f * f;
    }

    private float easeInCubic(float t) {
        return t * t * t;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getMeleeMode() {
        return this.meleeMode;
    }
}

