/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.sound.raevyx;

import com.leon.saintsdragons.client.sound.raevyx.RaevyxLightningBeamLoopSound;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RaevyxLightningBeamSoundController {
    private static final Map<Integer, RaevyxLightningBeamLoopSound> ACTIVE_SOUNDS = new HashMap<Integer, RaevyxLightningBeamLoopSound>();
    private static final Map<Integer, Boolean> LAST_BEAMING_STATE = new HashMap<Integer, Boolean>();

    private RaevyxLightningBeamSoundController() {
    }

    public static void tick(Minecraft minecraft) {
        if (minecraft == null || minecraft.m_91104_()) {
            return;
        }
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            RaevyxLightningBeamSoundController.stopAll(minecraft);
            return;
        }
        RaevyxLightningBeamSoundController.cleanupFinished(minecraft);
        HashSet<Integer> seen = new HashSet<Integer>();
        for (Entity entity : level.m_104735_()) {
            if (!(entity instanceof Raevyx)) continue;
            Raevyx raevyx = (Raevyx)entity;
            int id = raevyx.m_19879_();
            seen.add(id);
            boolean beaming = raevyx.isBeaming();
            boolean wasBeaming = LAST_BEAMING_STATE.getOrDefault(id, false);
            if (beaming && !wasBeaming) {
                RaevyxLightningBeamSoundController.startLoop(minecraft, raevyx);
            } else if (!beaming && wasBeaming) {
                RaevyxLightningBeamSoundController.stopLoop(minecraft, id);
            }
            LAST_BEAMING_STATE.put(id, beaming);
        }
        Iterator<Map.Entry<Integer, Boolean>> iterator = LAST_BEAMING_STATE.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Boolean> entry = iterator.next();
            if (seen.contains(entry.getKey())) continue;
            RaevyxLightningBeamSoundController.stopLoop(minecraft, entry.getKey());
            iterator.remove();
        }
    }

    private static void cleanupFinished(Minecraft minecraft) {
        Iterator<Map.Entry<Integer, RaevyxLightningBeamLoopSound>> iterator = ACTIVE_SOUNDS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, RaevyxLightningBeamLoopSound> entry = iterator.next();
            RaevyxLightningBeamLoopSound sound = entry.getValue();
            if (sound != null && !sound.m_7801_()) continue;
            minecraft.m_91106_().m_120399_((SoundInstance)sound);
            iterator.remove();
            LAST_BEAMING_STATE.put(entry.getKey(), false);
        }
    }

    private static void startLoop(Minecraft minecraft, Raevyx raevyx) {
        RaevyxLightningBeamSoundController.stopLoop(minecraft, raevyx.m_19879_());
        RaevyxLightningBeamLoopSound sound = new RaevyxLightningBeamLoopSound(raevyx);
        ACTIVE_SOUNDS.put(raevyx.m_19879_(), sound);
        minecraft.m_91106_().m_120367_((SoundInstance)sound);
    }

    private static void stopLoop(Minecraft minecraft, int entityId) {
        RaevyxLightningBeamLoopSound sound = ACTIVE_SOUNDS.remove(entityId);
        if (sound != null) {
            minecraft.m_91106_().m_120399_((SoundInstance)sound);
        }
    }

    private static void stopAll(Minecraft minecraft) {
        for (RaevyxLightningBeamLoopSound sound : ACTIVE_SOUNDS.values()) {
            minecraft.m_91106_().m_120399_((SoundInstance)sound);
        }
        ACTIVE_SOUNDS.clear();
        LAST_BEAMING_STATE.clear();
    }
}

