/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.sound.ignivorus;

import com.leon.saintsdragons.client.sound.ignivorus.IgnivorusFireBreathLoopSound;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class IgnivorusFireBreathSoundController {
    private static final Map<Integer, IgnivorusFireBreathLoopSound> ACTIVE_SOUNDS = new HashMap<Integer, IgnivorusFireBreathLoopSound>();
    private static final Map<Integer, Boolean> LAST_BREATHING_STATE = new HashMap<Integer, Boolean>();

    private IgnivorusFireBreathSoundController() {
    }

    public static void tick(Minecraft minecraft) {
        if (minecraft == null) {
            return;
        }
        if (minecraft.m_91104_()) {
            return;
        }
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            IgnivorusFireBreathSoundController.stopAll(minecraft);
            return;
        }
        IgnivorusFireBreathSoundController.cleanupFinished(minecraft);
        HashSet<Integer> seen = new HashSet<Integer>();
        for (Entity entity : level.m_104735_()) {
            if (!(entity instanceof Ignivorus)) continue;
            Ignivorus ignivorus = (Ignivorus)entity;
            int id = ignivorus.m_19879_();
            seen.add(id);
            boolean breathing = ignivorus.isBreathingFire();
            boolean wasBreathing = LAST_BREATHING_STATE.getOrDefault(id, false);
            if (breathing && !wasBreathing) {
                IgnivorusFireBreathSoundController.startLoop(minecraft, ignivorus);
            } else if (!breathing && wasBreathing) {
                IgnivorusFireBreathSoundController.stopLoop(minecraft, id);
            }
            LAST_BREATHING_STATE.put(id, breathing);
        }
        Iterator<Map.Entry<Integer, Boolean>> iterator = LAST_BREATHING_STATE.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Boolean> entry = iterator.next();
            if (seen.contains(entry.getKey())) continue;
            IgnivorusFireBreathSoundController.stopLoop(minecraft, entry.getKey());
            iterator.remove();
        }
    }

    private static void cleanupFinished(Minecraft minecraft) {
        Iterator<Map.Entry<Integer, IgnivorusFireBreathLoopSound>> iterator = ACTIVE_SOUNDS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, IgnivorusFireBreathLoopSound> entry = iterator.next();
            IgnivorusFireBreathLoopSound sound = entry.getValue();
            if (sound != null && !sound.m_7801_()) continue;
            minecraft.m_91106_().m_120399_((SoundInstance)sound);
            iterator.remove();
            LAST_BREATHING_STATE.put(entry.getKey(), false);
        }
    }

    private static void startLoop(Minecraft minecraft, Ignivorus ignivorus) {
        IgnivorusFireBreathSoundController.stopLoop(minecraft, ignivorus.m_19879_());
        IgnivorusFireBreathLoopSound sound = new IgnivorusFireBreathLoopSound(ignivorus);
        ACTIVE_SOUNDS.put(ignivorus.m_19879_(), sound);
        minecraft.m_91106_().m_120367_((SoundInstance)sound);
    }

    private static void stopLoop(Minecraft minecraft, int entityId) {
        IgnivorusFireBreathLoopSound sound = ACTIVE_SOUNDS.remove(entityId);
        if (sound != null) {
            minecraft.m_91106_().m_120399_((SoundInstance)sound);
        }
    }

    private static void stopAll(Minecraft minecraft) {
        for (IgnivorusFireBreathLoopSound sound : ACTIVE_SOUNDS.values()) {
            minecraft.m_91106_().m_120399_((SoundInstance)sound);
        }
        ACTIVE_SOUNDS.clear();
        LAST_BREATHING_STATE.clear();
    }
}

