/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.sound.ignivorus;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IgnivorusFireBreathLoopSound
extends AbstractTickableSoundInstance {
    private final Ignivorus dragon;

    public IgnivorusFireBreathLoopSound(Ignivorus dragon) {
        super(ModSounds.IGNIVORUS_FIRE_BREATHING.get(), SoundSource.NEUTRAL, SoundInstance.m_235150_());
        this.dragon = dragon;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = 1.45f;
        this.f_119574_ = 1.0f;
        this.f_119580_ = SoundInstance.Attenuation.LINEAR;
        this.updatePosition();
    }

    public Ignivorus getDragon() {
        return this.dragon;
    }

    public void m_7788_() {
        if (this.dragon == null || this.dragon.m_213877_() || !this.dragon.m_6084_()) {
            this.m_119609_();
            return;
        }
        if (!this.dragon.isBreathingFire()) {
            this.m_119609_();
            return;
        }
        this.updatePosition();
    }

    private void updatePosition() {
        Vec3 start = this.dragon.getFireBreathStart();
        if (start == null) {
            start = this.dragon.m_20182_().m_82520_(0.0, (double)this.dragon.m_20206_() * 0.65, 0.0);
        }
        this.f_119575_ = start.f_82479_;
        this.f_119576_ = start.f_82480_;
        this.f_119577_ = start.f_82481_;
        float sizeScale = (float)Math.max(1.0, (double)this.dragon.m_20205_());
        this.f_119573_ = 1.2f + sizeScale * 0.2f;
    }
}

