/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.stegonaut;

import com.leon.saintsdragons.client.model.stegonaut.StegonautModel;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@OnlyIn(value=Dist.CLIENT)
public class StegonautRenderer
extends GeoEntityRenderer<Stegonaut> {
    private BakedGeoModel lastBakedModel;
    private static final float MOUTH_X = 0.0f;
    private static final float MOUTH_Y = -0.2f;
    private static final float MOUTH_Z = 0.8f;

    public StegonautRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new StegonautModel());
    }

    public float getMotionAnimThreshold(Stegonaut animatable) {
        return 1.0E-6f;
    }

    protected float getDeathMaxRotation(Stegonaut entity) {
        return 0.0f;
    }

    public void preRender(PoseStack poseStack, Stegonaut entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float scale = 1.0f;
        poseStack.m_85841_(scale, scale, scale);
        this.f_114477_ = 1.5f * scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(@NotNull Stegonaut entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        this.lastBakedModel = this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)entity));
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        this.sampleAndStashLocatorsAccurate(entity);
    }

    private void sampleAndStashLocatorsAccurate(Stegonaut entity) {
        if (this.lastBakedModel == null || entity == null) {
            return;
        }
        this.lastBakedModel.getBone("head").ifPresent(b -> {
            Vec3 world = StegonautRenderer.transformLocator(b, 0.0f, -0.2f, 0.8f);
            if (world != null) {
                entity.setClientLocatorPosition("mouth_origin", world);
            }
        });
    }

    private static Vec3 transformLocator(GeoBone bone, float px, float py, float pz) {
        if (bone == null) {
            return null;
        }
        float lx = px / 16.0f;
        float ly = py / 16.0f;
        float lz = pz / 16.0f;
        Matrix4f worldMat = new Matrix4f((Matrix4fc)bone.getWorldSpaceMatrix());
        Vector4f in = new Vector4f(lx, ly, lz, 1.0f);
        Vector4f out = worldMat.transform(in);
        return new Vec3((double)out.x(), (double)out.y(), (double)out.z());
    }
}

