/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.nulljaw;

import com.leon.saintsdragons.client.model.nulljaw.NulljawModel;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@OnlyIn(value=Dist.CLIENT)
public class NulljawRenderer
extends GeoEntityRenderer<Nulljaw> {
    private BakedGeoModel lastBakedModel;
    private static final float FRONT_X = 0.0f;
    private static final float FRONT_Y = 0.0f;
    private static final float FRONT_Z = -5.0f;
    private static final float BACK_X = 0.0f;
    private static final float BACK_Y = 0.0f;
    private static final float BACK_Z = 10.0f;
    private static final float MOUTH_X = 0.0f;
    private static final float MOUTH_Y = 10.25f;
    private static final float MOUTH_Z = -24.0f;
    private static final float LEFT_FEET_X = 4.2f;
    private static final float LEFT_FEET_Y = 0.0f;
    private static final float LEFT_FEET_Z = -5.0f;
    private static final float RIGHT_FEET_X = -4.2f;
    private static final float RIGHT_FEET_Y = 0.0f;
    private static final float RIGHT_FEET_Z = -5.0f;
    private static final float PASSENGER_X = 0.0f;
    private static final float PASSENGER_Y = -3.0f;
    private static final float PASSENGER_Z = 0.0f;

    public NulljawRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new NulljawModel());
    }

    public float getMotionAnimThreshold(Nulljaw animatable) {
        return 1.0E-6f;
    }

    protected float getDeathMaxRotation(Nulljaw entity) {
        return 0.0f;
    }

    public void preRender(@NotNull PoseStack poseStack, Nulljaw entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.lastBakedModel = model;
        this.enableTrackingForBones(model);
        float scale = 1.0f;
        poseStack.m_85841_(scale, scale, scale);
        this.f_114477_ = 2.5f * scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(@NotNull Nulljaw entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        this.sampleAndStashLocatorsAccurate(entity);
    }

    private void enableTrackingForBones(BakedGeoModel model) {
        if (model == null) {
            return;
        }
        model.getBone("body").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("jawController").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("leftfrontfeetController").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("rightfrontfeetController").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("passengerBone").ifPresent(b -> b.setTrackingMatrices(true));
    }

    private void sampleAndStashLocatorsAccurate(Nulljaw entity) {
        if (this.lastBakedModel == null || entity == null) {
            return;
        }
        this.lastBakedModel.getBone("body").ifPresent(b -> {
            Vec3 back;
            Vec3 front = NulljawRenderer.transformLocator(b, 0.0f, 0.0f, -5.0f);
            if (front != null) {
                entity.setClientLocatorPosition("frontLocator", front);
            }
            if ((back = NulljawRenderer.transformLocator(b, 0.0f, 0.0f, 10.0f)) != null) {
                entity.setClientLocatorPosition("backLocator", back);
            }
        });
        this.lastBakedModel.getBone("jawController").ifPresent(b -> {
            Vec3 mouth = NulljawRenderer.transformLocator(b, 0.0f, 10.25f, -24.0f);
            if (mouth != null) {
                entity.setClientLocatorPosition("mouth_origin", mouth);
            }
        });
        this.lastBakedModel.getBone("leftfrontfeetController").ifPresent(b -> {
            Vec3 leftFeet = NulljawRenderer.transformLocator(b, 4.2f, 0.0f, -5.0f);
            if (leftFeet != null) {
                entity.setClientLocatorPosition("leftfrontfeetLocator", leftFeet);
            }
        });
        this.lastBakedModel.getBone("rightfrontfeetController").ifPresent(b -> {
            Vec3 rightFeet = NulljawRenderer.transformLocator(b, -4.2f, 0.0f, -5.0f);
            if (rightFeet != null) {
                entity.setClientLocatorPosition("rightfrontfeetLocator", rightFeet);
            }
        });
        this.lastBakedModel.getBone("passengerBone").ifPresent(b -> {
            Vec3 world = NulljawRenderer.transformLocator(b, 0.0f, -3.0f, 0.0f);
            if (world != null) {
                entity.setClientLocatorPosition("passengerLocator", world);
            }
        });
    }

    private static Vec3 transformLocator(GeoBone bone, float px, float py, float pz) {
        if (bone == null) {
            return null;
        }
        float lx = px / 16.0f;
        float ly = py / 16.0f;
        float lz = pz / 16.0f;
        Matrix4f worldMat = new Matrix4f((Matrix4fc)bone.getWorldSpaceMatrix());
        Vector4f in = new Vector4f(lx, ly, lz, 1.0f);
        Vector4f out = worldMat.transform(in);
        return new Vec3((double)out.x(), (double)out.y(), (double)out.z());
    }
}

