/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.layer.raevyx;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class RaevyxLightningBeamLayer
extends GeoRenderLayer<Raevyx> {
    private static final ResourceLocation INNER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/lightning_beam_inner.png");
    private static final ResourceLocation OUTER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/lightning_beam_outer.png");
    private static final ResourceLocation FEMALE_INNER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/female_lightning_beam_inner.png");
    private static final ResourceLocation FEMALE_OUTER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/female_lightning_beam_outer.png");
    private static final ResourceLocation[] MALE_STORM_FRAMES = RaevyxLightningBeamLayer.buildStormFrames("lightning_storm_", 8);
    private static final ResourceLocation[] FEMALE_STORM_SEQUENCE = new ResourceLocation[]{RaevyxLightningBeamLayer.particle("female_lightning_storm_0"), RaevyxLightningBeamLayer.particle("female_lightning_storm_3"), RaevyxLightningBeamLayer.particle("female_lightning_storm_5"), RaevyxLightningBeamLayer.particle("female_lightning_storm_6"), RaevyxLightningBeamLayer.particle("female_lightning_storm_7"), RaevyxLightningBeamLayer.particle("female_lightning_storm_6"), RaevyxLightningBeamLayer.particle("female_lightning_storm_5"), RaevyxLightningBeamLayer.particle("female_lightning_storm_3")};
    private static final float BASE_BEAM_WIDTH = 0.45f;
    private static final float OUTER_BEAM_BONUS = 0.15f;
    private static final float INNER_SPEED_MULTIPLIER = 0.25f;
    private static final float OUTER_SPEED_MULTIPLIER = 0.25f;
    private static final float BEAM_SHAKE_INTENSITY = 0.01f;
    private static final float LIGHTNING_SQUARE_PADDING = 0.1f;
    private static final float LIGHTNING_SEGMENT_LENGTH = 1.6f;
    private static final float LIGHTNING_SEGMENT_GAP = 0.45f;
    private static final float LIGHTNING_FRAME_INTERVAL_TICKS = 2.0f;
    private static final Map<Raevyx, BeamState> STATES = new WeakHashMap<Raevyx, BeamState>();
    private static final float APPEAR_TICKS = 5.0f;
    private static final float DISAPPEAR_TICKS = 6.0f;

    public RaevyxLightningBeamLayer() {
        super(null);
    }

    public void render(@NotNull PoseStack poseStack, Raevyx animatable, BakedGeoModel bakedModel, @NotNull RenderType renderType, @NotNull MultiBufferSource bufferSource, @NotNull VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        Vec3 end;
        Vec3 mouthWorld;
        BeamState state = STATES.computeIfAbsent(animatable, k -> new BeamState());
        boolean beaming = animatable.isBeaming();
        if (beaming) {
            state.disappear = 0.0f;
            state.appear = Mth.m_14036_((float)(state.appear + 0.2f), (float)0.0f, (float)1.0f);
            mouthWorld = RaevyxLightningBeamLayer.getBoneWorldPosition(bakedModel, "beamBone", animatable, partialTick);
            if (mouthWorld == null) {
                mouthWorld = animatable.computeHeadMouthOrigin(partialTick);
            }
            Vec3 predictedEnd = RaevyxLightningBeamLayer.predictBeamEnd(animatable, mouthWorld, partialTick);
            Vec3 serverEnd = animatable.getClientBeamEndPosition(partialTick);
            if (serverEnd == null) {
                end = predictedEnd;
            } else {
                double hspeed = animatable.m_20184_().m_165924_();
                float turnRate = Math.abs(Mth.m_14118_((float)animatable.f_20886_, (float)animatable.f_20885_));
                float weight = Mth.m_14036_((float)((float)(hspeed * 3.0 + (double)(turnRate / 90.0f))), (float)0.0f, (float)1.0f);
                end = RaevyxLightningBeamLayer.lerpVec(serverEnd, predictedEnd, weight);
            }
            state.lastMouth = mouthWorld;
            state.lastEnd = end;
        } else {
            if (state.lastMouth == null || state.lastEnd == null || state.appear <= 0.0f && state.disappear >= 1.0f) {
                return;
            }
            state.disappear = Mth.m_14036_((float)(state.disappear + 0.16666667f), (float)0.0f, (float)1.0f);
            state.appear = 0.0f;
            mouthWorld = state.lastMouth;
            end = state.lastEnd;
        }
        double ox = Mth.m_14139_((double)partialTick, (double)animatable.f_19854_, (double)animatable.m_20185_());
        double oy = Mth.m_14139_((double)partialTick, (double)animatable.f_19855_, (double)animatable.m_20186_());
        double oz = Mth.m_14139_((double)partialTick, (double)animatable.f_19856_, (double)animatable.m_20189_());
        float scale = 1.0f;
        Vec3 rawBeamPosition = end.m_82546_(mouthWorld);
        float length = (float)(rawBeamPosition.m_82553_() / (double)scale);
        if (length <= 0.001f) {
            return;
        }
        Vec3 vec3 = rawBeamPosition.m_82541_();
        float xRot = (float)Math.acos(vec3.f_82480_);
        float yRot = (float)Math.atan2(vec3.f_82481_, vec3.f_82479_);
        float ageInTicks = (float)animatable.f_19797_ + partialTick;
        float shakeByX = (float)Math.sin(ageInTicks * 4.0f) * 0.01f;
        float shakeByY = (float)Math.sin(ageInTicks * 4.0f + 1.2f) * 0.01f;
        float shakeByZ = (float)Math.sin(ageInTicks * 4.0f + 2.4f) * 0.01f;
        float mx = (float)((mouthWorld.f_82479_ - ox) / (double)scale);
        float my = (float)((mouthWorld.f_82480_ - oy) / (double)scale);
        float mz = (float)((mouthWorld.f_82481_ - oz) / (double)scale);
        poseStack.m_85836_();
        poseStack.m_252880_(mx + shakeByX, my + shakeByY, mz + shakeByZ);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - yRot) * 57.295776f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_((-1.5707964f + xRot) * 57.295776f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        float visScale = beaming ? RaevyxLightningBeamLayer.easeOutCubic(state.appear) : 1.0f - state.disappear;
        visScale = Mth.m_14036_((float)visScale, (float)0.0f, (float)1.0f);
        float scaledLength = Math.max(0.001f, length * visScale);
        float scaledWidth = Math.max(0.001f, 0.45f * (0.75f + 0.25f * visScale));
        ResourceLocation innerTex = animatable.isFemale() ? FEMALE_INNER_TEX : INNER_TEX;
        ResourceLocation outerTex = animatable.isFemale() ? FEMALE_OUTER_TEX : OUTER_TEX;
        this.renderBeam(animatable, poseStack, bufferSource, partialTick, scaledWidth, scaledLength, true, innerTex);
        this.renderBeam(animatable, poseStack, bufferSource, partialTick, scaledWidth, scaledLength, false, outerTex);
        this.renderLightningStormLayer(animatable, poseStack, bufferSource, partialTick, scaledWidth, scaledLength, visScale);
        poseStack.m_85849_();
    }

    private void renderBeam(Raevyx entity, PoseStack poseStack, MultiBufferSource source, float partialTicks, float width, float length, boolean inner, ResourceLocation texture) {
        float speed;
        VertexConsumer vertexconsumer;
        int vertices;
        poseStack.m_85836_();
        float startAlpha = 1.0f;
        float endAlpha = 1.0f;
        if (inner) {
            vertices = 4;
            vertexconsumer = source.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
            speed = 0.25f;
        } else {
            vertices = 8;
            vertexconsumer = source.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
            width += 0.15f;
            speed = 0.25f;
            endAlpha = 0.0f;
        }
        float v = ((float)entity.f_19797_ + partialTicks) * -0.25f * speed;
        float v1 = v + length * (inner ? 0.5f : 0.15f);
        float f4 = -width;
        float f5 = 0.0f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        for (int j = 0; j <= vertices; ++j) {
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float f7 = Mth.m_14089_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f8 = Mth.m_14031_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f9 = (float)j + 1.0f;
            vertexconsumer.m_252986_(matrix4f, f4 * 0.55f, f5 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f6, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f4, f5, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f6, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7, f8, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f9, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7 * 0.55f, f8 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f9, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        poseStack.m_85849_();
    }

    private static float easeOutCubic(float t) {
        float p = 1.0f - t;
        return 1.0f - p * p * p;
    }

    private static Vec3 lerpVec(Vec3 a, Vec3 b, float t) {
        t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f);
        return a.m_82549_(b.m_82546_(a).m_82490_((double)t));
    }

    private static Vec3 predictBeamEnd(Raevyx dragon, Vec3 mouthWorld, float partialTicks) {
        Vec3 aimDir = dragon.getBeamAimDirection();
        if (aimDir == null || aimDir.m_82556_() < 1.0E-6) {
            dragon.refreshBeamAimDirection(mouthWorld, true);
            aimDir = dragon.getBeamAimDirection();
        }
        if (aimDir == null || aimDir.m_82556_() < 1.0E-6) {
            LivingEntity cp = dragon.m_6688_();
            if (cp instanceof LivingEntity) {
                LivingEntity rider = cp;
                aimDir = rider.m_20252_(partialTicks).m_82541_();
            } else {
                LivingEntity tgt = dragon.m_5448_();
                if (tgt != null && tgt.m_6084_()) {
                    Vec3 aimPoint = tgt.m_20299_(partialTicks).m_82520_(0.0, -0.25, 0.0);
                    aimDir = aimPoint.m_82546_(mouthWorld).m_82541_();
                } else {
                    float yaw = Mth.m_14179_((float)partialTicks, (float)dragon.f_20886_, (float)dragon.f_20885_);
                    float pitch = Mth.m_14179_((float)partialTicks, (float)dragon.f_19860_, (float)dragon.m_146909_());
                    aimDir = Vec3.m_82498_((float)pitch, (float)yaw).m_82541_();
                }
            }
        }
        double MAX_DISTANCE = 24.0;
        Vec3 tentativeEnd = mouthWorld.m_82549_(aimDir.m_82490_(24.0));
        BlockHitResult hit = dragon.m_9236_().m_45547_(new ClipContext(mouthWorld, tentativeEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)dragon));
        return hit.m_6662_() != HitResult.Type.MISS ? hit.m_82450_() : tentativeEnd;
    }

    private void renderLightningStormLayer(Raevyx entity, PoseStack poseStack, MultiBufferSource source, float partialTicks, float baseWidth, float length, float visibility) {
        if (visibility <= 0.0f) {
            return;
        }
        float width = baseWidth + 0.1f;
        float totalLength = Math.max(0.001f, length);
        float segmentLen = Math.max(0.25f, Math.min(1.6f, totalLength));
        float cursor = 0.0f;
        int segmentIndex = 0;
        while (cursor < totalLength) {
            float remaining = totalLength - cursor;
            float currentLen = Math.min(segmentLen, remaining);
            float alphaPulse = 0.65f + 0.35f * Mth.m_14031_((float)(((float)entity.f_19797_ + partialTicks + (float)segmentIndex * 3.5f) * 0.45f));
            float alpha = Mth.m_14036_((float)(visibility * alphaPulse), (float)0.05f, (float)1.0f);
            ResourceLocation texture = RaevyxLightningBeamLayer.getStormFrameTexture(entity, partialTicks + (float)segmentIndex * 0.25f);
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, cursor);
            if (segmentIndex & true) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            this.renderLightningSegment(texture, poseStack, source, width, currentLen, alpha);
            poseStack.m_85849_();
            cursor += currentLen + 0.45f;
            ++segmentIndex;
        }
    }

    private void renderLightningSegment(ResourceLocation texture, PoseStack poseStack, MultiBufferSource source, float width, float length, float alpha) {
        VertexConsumer consumer = source.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        this.renderLightningPlane(consumer, matrix4f, normalMatrix, width, 0.0f, length, alpha, true, true);
        this.renderLightningPlane(consumer, matrix4f, normalMatrix, -width, 0.0f, length, alpha, true, false);
        this.renderLightningPlane(consumer, matrix4f, normalMatrix, width, 0.0f, length, alpha, false, true);
        this.renderLightningPlane(consumer, matrix4f, normalMatrix, -width, 0.0f, length, alpha, false, false);
    }

    private static ResourceLocation getStormFrameTexture(Raevyx entity, float partialTicks) {
        float ticks = ((float)entity.f_19797_ + partialTicks) / 2.0f;
        if (entity.isFemale()) {
            int idx = (int)(ticks % (float)FEMALE_STORM_SEQUENCE.length);
            return FEMALE_STORM_SEQUENCE[idx];
        }
        int idx = (int)(ticks % (float)MALE_STORM_FRAMES.length);
        return MALE_STORM_FRAMES[idx];
    }

    private void renderLightningPlane(VertexConsumer consumer, Matrix4f poseMatrix, Matrix3f normalMatrix, float fixedCoord, float zStart, float zEnd, float alpha, boolean axisX, boolean positive) {
        float half = Math.max(0.001f, Math.abs(fixedCoord));
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        if (axisX) {
            Vector3f normalVec = new Vector3f(positive ? 1.0f : -1.0f, 0.0f, 0.0f);
            normalMatrix.transform(normalVec);
            float x = fixedCoord;
            float yMin = -half;
            float yMax = half;
            consumer.m_252986_(poseMatrix, x, yMin, zStart).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_5601_(normalVec.x(), normalVec.y(), normalVec.z()).m_5752_();
            consumer.m_252986_(poseMatrix, x, yMin, zEnd).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_5601_(normalVec.x(), normalVec.y(), normalVec.z()).m_5752_();
            consumer.m_252986_(poseMatrix, x, yMax, zEnd).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_5601_(normalVec.x(), normalVec.y(), normalVec.z()).m_5752_();
            consumer.m_252986_(poseMatrix, x, yMax, zStart).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_5601_(normalVec.x(), normalVec.y(), normalVec.z()).m_5752_();
        } else {
            Vector3f normalVec = new Vector3f(0.0f, positive ? 1.0f : -1.0f, 0.0f);
            normalMatrix.transform(normalVec);
            float y = fixedCoord;
            float xMin = -half;
            float xMax = half;
            consumer.m_252986_(poseMatrix, xMin, y, zStart).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_5601_(normalVec.x(), normalVec.y(), normalVec.z()).m_5752_();
            consumer.m_252986_(poseMatrix, xMin, y, zEnd).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_5601_(normalVec.x(), normalVec.y(), normalVec.z()).m_5752_();
            consumer.m_252986_(poseMatrix, xMax, y, zEnd).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_5601_(normalVec.x(), normalVec.y(), normalVec.z()).m_5752_();
            consumer.m_252986_(poseMatrix, xMax, y, zStart).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_5601_(normalVec.x(), normalVec.y(), normalVec.z()).m_5752_();
        }
    }

    private static ResourceLocation[] buildStormFrames(String prefix, int count) {
        ResourceLocation[] frames = new ResourceLocation[count];
        for (int i = 0; i < count; ++i) {
            frames[i] = RaevyxLightningBeamLayer.particle(prefix + i);
        }
        return frames;
    }

    private static ResourceLocation particle(String path) {
        return SaintsDragonsCommon.rl("textures/particle/raevyx/" + path + ".png");
    }

    private static Vec3 getBoneWorldPosition(BakedGeoModel model, String boneName, Raevyx entity, float partialTick) {
        if (model == null || boneName == null) {
            return null;
        }
        Optional boneOpt = model.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return null;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        Matrix4f worldMat = new Matrix4f((Matrix4fc)bone.getWorldSpaceMatrix());
        Vector4f pivotWorld = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        worldMat.transform(pivotWorld);
        return new Vec3((double)pivotWorld.x(), (double)pivotWorld.y(), (double)pivotWorld.z());
    }

    private static final class BeamState {
        float appear;
        float disappear;
        Vec3 lastMouth;
        Vec3 lastEnd;

        private BeamState() {
        }
    }
}

