/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.layer.raevyx;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class RaevyxGlowLayer
extends GeoRenderLayer<Raevyx> {
    private static final ResourceLocation GLOW_TEXTURE = SaintsDragonsCommon.rl("textures/entity/raevyx/raevyx_glow.png");
    private static final ResourceLocation FEMALE_GLOW_TEXTURE = SaintsDragonsCommon.rl("textures/entity/raevyx/raevyx_female_glow.png");

    public RaevyxGlowLayer(GeoRenderer<Raevyx> renderer) {
        super(renderer);
    }

    public void render(@NotNull PoseStack poseStack, Raevyx animatable, BakedGeoModel bakedModel, @NotNull RenderType renderType, @NotNull MultiBufferSource bufferSource, @NotNull VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!animatable.isBeamGlowActive()) {
            return;
        }
        float ticks = (float)animatable.f_19797_ + partialTick;
        float pulseBase = 0.0f;
        float pulseSwing = 1.0f;
        float pulse = pulseBase + pulseSwing * (0.5f + 0.5f * Mth.m_14031_((float)(ticks * 0.25f)));
        ResourceLocation texture = animatable.isFemale() ? FEMALE_GLOW_TEXTURE : GLOW_TEXTURE;
        RenderType glowType = RenderType.m_110473_((ResourceLocation)texture);
        VertexConsumer glowBuffer = bufferSource.m_6299_(glowType);
        this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, glowType, glowBuffer, partialTick, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, pulse);
    }
}

