/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.layer.ignivorus;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class IgnivorusGlowLayer
extends GeoRenderLayer<Ignivorus> {
    private static final ResourceLocation GLOW_TEXTURE = SaintsDragonsCommon.rl("textures/entity/ignivorus/ignivorus_glow.png");
    private static final ResourceLocation FEMALE_GLOW_TEXTURE = SaintsDragonsCommon.rl("textures/entity/ignivorus/ignivorus_glow_female.png");
    private static final ResourceLocation GLOW_TEXTURE_SECOND_VARIANT = SaintsDragonsCommon.rl("textures/entity/ignivorus/ignivorus_second_variant_glow.png");
    private static final ResourceLocation FEMALE_GLOW_TEXTURE_SECOND_VARIANT = SaintsDragonsCommon.rl("textures/entity/ignivorus/ignivorus_second_variant_glow_female.png");

    public IgnivorusGlowLayer(GeoRenderer<Ignivorus> renderer) {
        super(renderer);
    }

    public void render(@NotNull PoseStack poseStack, Ignivorus animatable, BakedGeoModel bakedModel, @NotNull RenderType renderType, @NotNull MultiBufferSource bufferSource, @NotNull VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!animatable.isBreathingFire()) {
            return;
        }
        float ticks = (float)animatable.f_19797_ + partialTick;
        float pulse = 0.5f + 0.5f * Mth.m_14031_((float)(ticks * 0.2f));
        float streamProgress = (float)animatable.getFireBreathProgress() / 40.0f;
        float alpha = Mth.m_14036_((float)streamProgress, (float)0.0f, (float)1.0f) * (0.35f + 0.65f * pulse);
        if (alpha <= 0.01f) {
            return;
        }
        ResourceLocation glowTexture = this.getGlowTexture(animatable);
        RenderType glowType = RenderType.m_110473_((ResourceLocation)glowTexture);
        VertexConsumer glowBuffer = bufferSource.m_6299_(glowType);
        this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, glowType, glowBuffer, partialTick, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
    }

    private ResourceLocation getGlowTexture(Ignivorus animatable) {
        int variant = animatable.getTextureVariant();
        boolean isFemale = animatable.isFemale();
        if (variant == 1) {
            return isFemale ? FEMALE_GLOW_TEXTURE_SECOND_VARIANT : GLOW_TEXTURE_SECOND_VARIANT;
        }
        return isFemale ? FEMALE_GLOW_TEXTURE : GLOW_TEXTURE;
    }
}

