/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.layer.ignivorus;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class IgnivorusFireConeLayer
extends GeoRenderLayer<Ignivorus> {
    private static final ResourceLocation FIRE_CORE_TEXTURE = SaintsDragonsCommon.rl("textures/particle/ignivorus/fire_breath_core.png");
    private static final ResourceLocation FIRE_FLAME_TEXTURE = SaintsDragonsCommon.rl("textures/particle/ignivorus/fire_breath_flame.png");
    private static final double MAX_VISUAL_DISTANCE = 64.0;
    private static final float MODEL_SCALE = 1.0f;
    private static final float CONE_START_WIDTH = 1.0f;
    private static final float CONE_END_WIDTH = 2.5f;
    private static final float CORE_WIDTH_MULTIPLIER = 0.5f;
    private static final float OUTER_GLOW_BONUS = 0.3f;
    private static final float ANIMATION_SPEED = -0.45f;
    private static final float CORE_ANIMATION_SPEED = -0.6f;
    private static final int CONE_SEGMENTS = 8;
    private static final Map<Ignivorus, ConeState> STATES = new WeakHashMap<Ignivorus, ConeState>();
    private static final float APPEAR_TICKS = 5.0f;
    private static final float DISAPPEAR_TICKS = 6.0f;

    public IgnivorusFireConeLayer() {
        super(null);
    }

    public void render(@NotNull PoseStack poseStack, Ignivorus animatable, BakedGeoModel bakedModel, @NotNull RenderType renderType, @NotNull MultiBufferSource bufferSource, @NotNull VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        Level level;
        Vec3 endWorld;
        Vec3 startWorld;
        ConeState state = STATES.computeIfAbsent(animatable, k -> new ConeState());
        boolean breathing = animatable.isBreathingFire();
        if (breathing) {
            state.disappear = 0.0f;
            state.appear = Mth.m_14036_((float)(state.appear + 0.2f), (float)0.0f, (float)1.0f);
            startWorld = animatable.getFireBreathStartAnchor(partialTick);
            if (startWorld == null) {
                return;
            }
            Vec3 aimDir = Vec3.m_82498_((float)animatable.m_146909_(), (float)animatable.f_20885_);
            Vec3 visualEnd = startWorld.m_82549_(aimDir.m_82490_(64.0));
            Vec3 serverEnd = animatable.getFireBreathTarget();
            endWorld = serverEnd != null ? serverEnd : visualEnd;
            Vec3 delta = endWorld.m_82546_(startWorld);
            if (delta.m_82553_() > 64.0) {
                endWorld = startWorld.m_82549_(delta.m_82541_().m_82490_(64.0));
            }
            state.lastStart = startWorld;
            state.lastEnd = endWorld;
        } else {
            if (state.lastStart == null || state.lastEnd == null || state.appear <= 0.0f && state.disappear >= 1.0f) {
                return;
            }
            state.disappear = Mth.m_14036_((float)(state.disappear + 0.16666667f), (float)0.0f, (float)1.0f);
            state.appear = 0.0f;
            startWorld = state.lastStart;
            endWorld = state.lastEnd;
        }
        double ox = Mth.m_14139_((double)partialTick, (double)animatable.f_19854_, (double)animatable.m_20185_());
        double oy = Mth.m_14139_((double)partialTick, (double)animatable.f_19855_, (double)animatable.m_20186_());
        double oz = Mth.m_14139_((double)partialTick, (double)animatable.f_19856_, (double)animatable.m_20189_());
        Vec3 rawConeVector = endWorld.m_82546_(startWorld);
        float baseLength = (float)(rawConeVector.m_82553_() / 1.0);
        if (baseLength <= 0.001f) {
            return;
        }
        int progress = animatable.getFireBreathProgress();
        double progressRatio = Math.min(1.0, (double)progress / 40.0);
        float length = (float)((double)baseLength * progressRatio);
        if (length <= 0.001f) {
            return;
        }
        Vec3 direction = rawConeVector.m_82541_();
        float xRot = (float)Math.acos(direction.f_82480_);
        float yRot = (float)Math.atan2(direction.f_82481_, direction.f_82479_);
        float sx = (float)((startWorld.f_82479_ - ox) / 1.0);
        float sy = (float)((startWorld.f_82480_ - oy) / 1.0);
        float sz = (float)((startWorld.f_82481_ - oz) / 1.0);
        poseStack.m_85836_();
        poseStack.m_252880_(sx, sy, sz);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - yRot) * 57.295776f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_((-1.5707964f + xRot) * 57.295776f));
        float visScale = breathing ? IgnivorusFireConeLayer.easeOutCubic(state.appear) : 1.0f - state.disappear;
        visScale = Mth.m_14036_((float)visScale, (float)0.0f, (float)1.0f);
        float scaledLength = Math.max(0.001f, length * visScale);
        float ageInTicks = (float)animatable.f_19797_ + partialTick;
        float pulse = 0.85f + Mth.m_14031_((float)(ageInTicks * 0.3f)) * 0.15f;
        this.renderConeLayer(animatable, poseStack, bufferSource, partialTick, scaledLength, visScale, pulse, true);
        this.renderConeLayer(animatable, poseStack, bufferSource, partialTick, scaledLength, visScale, pulse, false);
        if (breathing && (level = animatable.m_9236_()) instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            this.spawnFlameParticles(animatable, clientLevel, startWorld, endWorld, partialTick);
        }
        poseStack.m_85849_();
    }

    private void renderConeLayer(Ignivorus entity, PoseStack poseStack, MultiBufferSource source, float partialTicks, float length, float visScale, float pulse, boolean isCore) {
        float colorB;
        float colorG;
        float colorR;
        float endAlpha;
        float startAlpha;
        float endWidth;
        float startWidth;
        poseStack.m_85836_();
        ResourceLocation texture = isCore ? FIRE_CORE_TEXTURE : FIRE_FLAME_TEXTURE;
        float animSpeed = isCore ? -0.6f : -0.45f;
        VertexConsumer vertexConsumer = source.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
        float uvOffset = ((float)entity.f_19797_ + partialTicks) * animSpeed;
        float baseStartWidth = 1.0f * visScale;
        float baseEndWidth = 2.5f * visScale;
        if (isCore) {
            startWidth = baseStartWidth * 0.5f;
            endWidth = baseEndWidth * 0.5f;
            startAlpha = 1.0f;
            endAlpha = 0.8f;
            colorR = 1.0f;
            colorG = 1.0f;
            colorB = 0.9f;
        } else {
            startWidth = baseStartWidth + 0.3f;
            endWidth = baseEndWidth + 0.3f;
            startAlpha = 0.9f * pulse;
            endAlpha = 0.5f * pulse;
            colorR = 1.0f;
            colorG = 0.85f;
            colorB = 0.6f;
        }
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        for (int i = 0; i <= 8; ++i) {
            float angle = (float)i * ((float)Math.PI * 2) / 8.0f;
            float nextAngle = (float)(i + 1) * ((float)Math.PI * 2) / 8.0f;
            float x1 = Mth.m_14089_((float)angle) * startWidth;
            float y1 = Mth.m_14031_((float)angle) * startWidth;
            float x2 = Mth.m_14089_((float)angle) * endWidth;
            float y2 = Mth.m_14031_((float)angle) * endWidth;
            float u = (float)i / 8.0f;
            float uNext = (float)(i + 1) / 8.0f;
            vertexConsumer.m_252986_(matrix4f, x1, y1, 0.0f).m_85950_(colorR, colorG, colorB, startAlpha).m_7421_(u, uvOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, x2, y2, length).m_85950_(colorR, colorG, colorB, endAlpha).m_7421_(u, uvOffset + length * 0.2f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            float x3 = Mth.m_14089_((float)nextAngle) * endWidth;
            float y3 = Mth.m_14031_((float)nextAngle) * endWidth;
            vertexConsumer.m_252986_(matrix4f, x3, y3, length).m_85950_(colorR, colorG, colorB, endAlpha).m_7421_(uNext, uvOffset + length * 0.2f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            float x4 = Mth.m_14089_((float)nextAngle) * startWidth;
            float y4 = Mth.m_14031_((float)nextAngle) * startWidth;
            vertexConsumer.m_252986_(matrix4f, x4, y4, 0.0f).m_85950_(colorR, colorG, colorB, startAlpha).m_7421_(uNext, uvOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        }
        poseStack.m_85849_();
    }

    private static float easeOutCubic(float t) {
        float p = 1.0f - t;
        return 1.0f - p * p * p;
    }

    private void spawnFlameParticles(Ignivorus dragon, ClientLevel level, Vec3 start, Vec3 end, float partialTick) {
        int i;
        if (dragon.f_19797_ % 2 != 0) {
            return;
        }
        RandomSource random = dragon.m_217043_();
        int progress = dragon.getFireBreathProgress();
        double progressRatio = Math.min(1.0, (double)progress / 40.0);
        Vec3 currentEnd = start.m_82549_(end.m_82546_(start).m_82490_(progressRatio));
        Vec3 direction = currentEnd.m_82546_(start).m_82541_();
        double distance = start.m_82554_(currentEnd);
        int segments = Math.max(3, (int)(distance / 2.0));
        segments = Math.min(segments, 20);
        for (i = 1; i < segments; ++i) {
            double ratio = (double)i / (double)segments;
            Vec3 position = start.m_82549_(currentEnd.m_82546_(start).m_82490_(ratio));
            float coneWidth = Mth.m_14179_((float)((float)ratio), (float)1.0f, (float)2.5f);
            int particlesPerSegment = 2 + random.m_188503_(2);
            for (int j = 0; j < particlesPerSegment; ++j) {
                double offsetDist = random.m_188500_() * (double)coneWidth * 0.8;
                double offsetAngle = random.m_188500_() * Math.PI * 2.0;
                Vec3 perpendicular = direction.m_82537_(new Vec3(0.0, 1.0, 0.0));
                if (perpendicular.m_82556_() < 0.001) {
                    perpendicular = direction.m_82537_(new Vec3(1.0, 0.0, 0.0));
                }
                perpendicular = perpendicular.m_82541_();
                Vec3 perpendicular2 = direction.m_82537_(perpendicular).m_82541_();
                double offsetX = Math.cos(offsetAngle) * offsetDist;
                double offsetY = Math.sin(offsetAngle) * offsetDist;
                Vec3 particlePos = position.m_82549_(perpendicular.m_82490_(offsetX).m_82549_(perpendicular2.m_82490_(offsetY)));
                Vec3 velocity = direction.m_82490_(0.02 + random.m_188500_() * 0.03);
                Vec3 radialVel = particlePos.m_82546_(position).m_82541_().m_82490_(0.01 + random.m_188500_() * 0.02);
                velocity = velocity.m_82549_(radialVel);
                float particleType = random.m_188501_();
                if (particleType < 0.5f) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
                    continue;
                }
                if (particleType < 0.8f) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_ * 0.5, velocity.f_82480_ * 0.5, velocity.f_82481_ * 0.5);
                    continue;
                }
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_ * 0.3, velocity.f_82480_ + 0.01, velocity.f_82481_ * 0.3);
            }
        }
        if (progressRatio > 0.5) {
            for (i = 0; i < 3; ++i) {
                double spread = 0.5;
                Vec3 emberPos = currentEnd.m_82520_((random.m_188500_() - 0.5) * spread, (random.m_188500_() - 0.5) * spread, (random.m_188500_() - 0.5) * spread);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, emberPos.f_82479_, emberPos.f_82480_, emberPos.f_82481_, (random.m_188500_() - 0.5) * 0.02, random.m_188500_() * 0.02, (random.m_188500_() - 0.5) * 0.02);
            }
        }
    }

    private static final class ConeState {
        float appear;
        float disappear;
        Vec3 lastStart;
        Vec3 lastEnd;

        private ConeState() {
        }
    }
}

