/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.ignivorus;

import com.leon.saintsdragons.client.model.ignivorus.IgnivorusModel;
import com.leon.saintsdragons.client.renderer.layer.ignivorus.IgnivorusFireConeLayer;
import com.leon.saintsdragons.client.renderer.layer.ignivorus.IgnivorusGlowLayer;
import com.leon.saintsdragons.client.renderer.layer.ignivorus.IgnivorusMouthSmokeLayer;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class IgnivorusRenderer
extends GeoEntityRenderer<Ignivorus> {
    private static final float PASSENGER_X = 0.0f;
    private static final float PASSENGER_Y = -3.0f;
    private static final float PASSENGER_Z = 0.0f;
    private static final String FIRE_BONE = "fireBone";
    private static final String PASSENGER_BONE = "passengerBone";
    private static final String MOUTH_LOCATOR_BONE = "mouth_origin";
    private static final String BODY_LOCATOR_BONE = "body_locator";
    private BakedGeoModel lastBakedModel;

    public IgnivorusRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new IgnivorusModel());
        this.addRenderLayer(new IgnivorusMouthSmokeLayer());
        this.addRenderLayer(new IgnivorusFireConeLayer());
        this.addRenderLayer(new IgnivorusGlowLayer((GeoRenderer<Ignivorus>)this));
    }

    public float getMotionAnimThreshold(Ignivorus animatable) {
        return 1.0E-6f;
    }

    protected float getDeathMaxRotation(Ignivorus entity) {
        return 0.0f;
    }

    public void preRender(PoseStack poseStack, Ignivorus entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float scale = 1.0f;
        poseStack.m_85841_(scale, scale, scale);
        this.f_114477_ = 5.0f * scale;
        this.lastBakedModel = model;
        this.enableTrackingForBones(model);
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private void enableTrackingForBones(BakedGeoModel model) {
        if (model == null) {
            return;
        }
        model.getBone(PASSENGER_BONE).ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone(FIRE_BONE).ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone(MOUTH_LOCATOR_BONE).ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone(BODY_LOCATOR_BONE).ifPresent(b -> b.setTrackingMatrices(true));
    }

    public void render(@NotNull Ignivorus entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        if (this.lastBakedModel == null) {
            return;
        }
        this.lastBakedModel.getBone(PASSENGER_BONE).ifPresent(b -> {
            Vec3 world = this.transformLocator((GeoBone)b, 0.0f, -3.0f, 0.0f);
            if (world != null) {
                entity.setClientLocatorPosition("passengerLocator", world);
            }
        });
        this.lastBakedModel.getBone(FIRE_BONE).ifPresent(b -> {
            Vec3 world = this.transformLocator((GeoBone)b, 0.0f, 0.0f, 0.0f);
            if (world != null) {
                entity.setClientLocatorPosition("fireBoneOrigin", world);
            }
        });
        this.lastBakedModel.getBone(MOUTH_LOCATOR_BONE).ifPresent(b -> {
            Vec3 world = this.transformLocator((GeoBone)b, 0.0f, 0.0f, 0.0f);
            if (world != null) {
                entity.setClientLocatorPosition(MOUTH_LOCATOR_BONE, world);
            }
        });
        this.lastBakedModel.getBone(BODY_LOCATOR_BONE).ifPresent(b -> {
            Vec3 world = this.transformLocator((GeoBone)b, 0.0f, 0.0f, 0.0f);
            if (world != null) {
                entity.setClientLocatorPosition(BODY_LOCATOR_BONE, world);
            }
        });
    }

    private Vec3 transformLocator(GeoBone bone, float px, float py, float pz) {
        if (bone == null || bone.getWorldSpaceMatrix() == null) {
            return null;
        }
        float lx = px / 16.0f;
        float ly = py / 16.0f;
        float lz = pz / 16.0f;
        Matrix4f worldMat = new Matrix4f((Matrix4fc)bone.getWorldSpaceMatrix());
        Vector4f in = new Vector4f(lx, ly, lz, 1.0f);
        Vector4f out = worldMat.transform(in);
        return new Vec3((double)out.x(), (double)out.y(), (double)out.z());
    }
}

