/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.particle.raevyx;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

final class RaevyxParticleSprites {
    private static final ResourceLocation[] STORM_MALE = RaevyxParticleSprites.resourceArray("raevyx/lightning_storm_0", "raevyx/lightning_storm_1", "raevyx/lightning_storm_2", "raevyx/lightning_storm_3", "raevyx/lightning_storm_4", "raevyx/lightning_storm_5", "raevyx/lightning_storm_6", "raevyx/lightning_storm_7");
    private static final ResourceLocation[] STORM_FEMALE = RaevyxParticleSprites.resourceArray("raevyx/female_lightning_storm_0", "raevyx/lightning_storm_1", "raevyx/lightning_storm_2", "raevyx/female_lightning_storm_3", "raevyx/lightning_storm_4", "raevyx/female_lightning_storm_5", "raevyx/female_lightning_storm_6", "raevyx/female_lightning_storm_7");
    private static TextureAtlasSprite[] stormMaleSprites;
    private static TextureAtlasSprite[] stormFemaleSprites;

    private RaevyxParticleSprites() {
    }

    static TextureAtlasSprite[] storm(boolean female) {
        return female ? RaevyxParticleSprites.getStormFemale() : RaevyxParticleSprites.getStormMale();
    }

    static int frameIndexByProgress(TextureAtlasSprite[] frames, float progress) {
        if (frames.length == 0) {
            return 0;
        }
        float clamped = Mth.m_14036_((float)progress, (float)0.0f, (float)0.999f);
        return Mth.m_14045_((int)((int)(clamped * (float)frames.length)), (int)0, (int)(frames.length - 1));
    }

    private static TextureAtlasSprite[] getStormMale() {
        if (stormMaleSprites == null) {
            stormMaleSprites = RaevyxParticleSprites.resolveSprites(STORM_MALE);
        }
        return stormMaleSprites;
    }

    private static TextureAtlasSprite[] getStormFemale() {
        if (stormFemaleSprites == null) {
            stormFemaleSprites = RaevyxParticleSprites.resolveSprites(STORM_FEMALE);
        }
        return stormFemaleSprites;
    }

    private static TextureAtlasSprite[] resolveSprites(ResourceLocation[] resources) {
        try {
            TextureAtlas atlas = Minecraft.m_91087_().f_91061_.f_107296_;
            if (atlas == null) {
                return new TextureAtlasSprite[0];
            }
            TextureAtlasSprite[] sprites = new TextureAtlasSprite[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                sprites[i] = atlas.m_118316_(resources[i]);
            }
            return sprites;
        }
        catch (Exception e) {
            SaintsDragonsCommon.LOGGER.error("Failed to resolve particle sprites", (Throwable)e);
            return new TextureAtlasSprite[0];
        }
    }

    private static ResourceLocation[] resourceArray(String ... paths) {
        ResourceLocation[] array = new ResourceLocation[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            array[i] = SaintsDragonsCommon.rl(paths[i]);
        }
        return array;
    }
}

