/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.particle.raevyx;

import com.leon.saintsdragons.client.particle.raevyx.RaevyxParticleSprites;
import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningChainData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RaevyxLightningChainParticle
extends TextureSheetParticle {
    private final TextureAtlasSprite[] frames;
    private final Vec3 startPos;
    private final Vec3 endPos;
    private final float totalDistance;
    private final float speed;
    private float progress = 0.0f;

    protected RaevyxLightningChainParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float size, SpriteSet spriteSet, Vec3 startPos, Vec3 endPos, boolean female) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        TextureAtlasSprite[] resolved = RaevyxParticleSprites.storm(female);
        if (resolved.length == 0) {
            resolved = new TextureAtlasSprite[]{spriteSet.m_5819_(0, 1)};
        }
        this.frames = resolved;
        this.startPos = startPos;
        this.endPos = endPos;
        this.totalDistance = (float)startPos.m_82554_(endPos);
        this.speed = 0.15f;
        this.f_107663_ = size;
        this.f_107225_ = (int)(this.totalDistance / this.speed) + 10;
        this.m_107250_(size * 2.0f, size * 2.0f);
        this.m_108337_(this.frames[0]);
        this.m_107264_(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.progress = Math.min(1.0f, (float)this.f_107224_ / (float)Math.max(1, this.f_107225_ - 10));
            Vec3 currentPos = this.startPos.m_165921_(this.endPos, (double)this.progress);
            this.m_107264_(currentPos.f_82479_, currentPos.f_82480_, currentPos.f_82481_);
            this.updateSprite();
            if (this.progress > 0.8f) {
                this.f_107230_ = 1.0f - (this.progress - 0.8f) / 0.2f;
            }
        }
    }

    private void updateSprite() {
        if (this.frames.length == 0) {
            return;
        }
        int frameIndex = this.f_107224_ / 2 % this.frames.length;
        this.m_108337_(this.frames[frameIndex]);
    }

    public void m_5744_(@Nonnull VertexConsumer buffer, @Nonnull Camera camera, float partialTicks) {
        Vec3 cam = camera.m_90583_();
        float cx = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cam.m_7096_());
        float cy = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cam.m_7098_());
        float cz = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cam.m_7094_());
        Quaternionf camQ = new Quaternionf();
        camQ.rotateY((float)Math.toRadians(-camera.m_90590_()));
        Vector3f[] corners = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f v = corners[i];
            v.rotate((Quaternionfc)camQ);
            v.mul(size);
            v.add(cx, cy, cz);
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int light = this.m_6355_(partialTicks);
        buffer.m_5483_((double)corners[0].x(), (double)corners[0].y(), (double)corners[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)corners[1].x(), (double)corners[1].y(), (double)corners[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)corners[2].x(), (double)corners[2].y(), (double)corners[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)corners[3].x(), (double)corners[3].y(), (double)corners[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    public int m_6355_(float partialTicks) {
        return 240;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<RaevyxLightningChainData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@Nonnull RaevyxLightningChainData data, @Nonnull ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RaevyxLightningChainParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, data.size(), this.spriteSet, data.startPos(), data.endPos(), data.female());
        }
    }
}

