/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.raevyx;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class RaevyxModel
extends DefaultedEntityGeoModel<Raevyx> {
    private static final ResourceLocation ADULT_MODEL = SaintsDragonsCommon.rl("geo/entity/raevyx.geo.json");
    private static final ResourceLocation FEMALE_MODEL = SaintsDragonsCommon.rl("geo/entity/raevyx.geo.json");
    private static final ResourceLocation BABY_MODEL = SaintsDragonsCommon.rl("geo/entity/baby_raevyx.geo.json");
    private static final ResourceLocation ADULT_ANIM = SaintsDragonsCommon.rl("animations/entity/raevyx.animation.json");
    private static final ResourceLocation BABY_ANIM = SaintsDragonsCommon.rl("animations/entity/baby_raevyx.animation.json");
    private static final ResourceLocation MALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/raevyx/raevyx.png");
    private static final ResourceLocation FEMALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/raevyx/raevyx_female.png");
    private static final ResourceLocation BABY_TEXTURE = SaintsDragonsCommon.rl("textures/entity/raevyx/baby_raevyx.png");

    public RaevyxModel() {
        super(SaintsDragonsCommon.rl("raevyx"));
    }

    public ResourceLocation getModelResource(Raevyx entity) {
        if (entity.m_6162_()) {
            return BABY_MODEL;
        }
        if (entity.isFemale()) {
            return FEMALE_MODEL;
        }
        return ADULT_MODEL;
    }

    public ResourceLocation getTextureResource(Raevyx entity) {
        if (entity.m_6162_()) {
            return BABY_TEXTURE;
        }
        return entity.isFemale() ? FEMALE_TEXTURE : MALE_TEXTURE;
    }

    public ResourceLocation getAnimationResource(Raevyx entity) {
        return entity.m_6162_() ? BABY_ANIM : ADULT_ANIM;
    }

    public void setCustomAnimations(Raevyx entity, long instanceId, AnimationState<Raevyx> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        EntityModelData modelData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (modelData == null) {
            return;
        }
        float partialTick = animationState.getPartialTick();
        if (entity.m_6084_()) {
            if (entity.isTamingStunned()) {
                return;
            }
            if (entity.m_21224_()) {
                return;
            }
            this.applyBodyRotationDeviation(entity, partialTick);
            this.applyBankingRoll(entity, animationState);
            this.applyNeckFollow(entity, modelData, partialTick);
            this.applyNeckBankingLean(entity, partialTick);
            this.applyGroundNeckTurn(entity, partialTick);
            this.applyTailDrag(entity, partialTick);
        }
    }

    private void applyBodyRotationDeviation(Raevyx entity, float partialTick) {
        Optional rootOpt = this.getBone("body");
        if (rootOpt.isEmpty()) {
            return;
        }
        GeoBone root = (GeoBone)rootOpt.get();
        BoneSnapshot snap = root.getInitialSnapshot();
        double deviation = entity.bodyRotDeviation.get(partialTick);
        float deviationRad = (float)(deviation * 0.01745329238474369);
        root.setRotY(snap.getRotY() - deviationRad);
    }

    private void applyBankingRoll(Raevyx entity, AnimationState<Raevyx> state) {
        Optional bodyOpt = this.getBone("body");
        if (bodyOpt.isEmpty()) {
            return;
        }
        GeoBone body = (GeoBone)bodyOpt.get();
        BoneSnapshot snap = body.getInitialSnapshot();
        float partialTick = state.getPartialTick();
        float bankAngleDeg = entity.getBankAngleDegrees(partialTick);
        float bankAngleRad = Mth.m_14036_((float)(-bankAngleDeg * ((float)Math.PI / 180)), (float)-1.5707964f, (float)1.5707964f);
        body.setRotZ(snap.getRotZ() + bankAngleRad);
    }

    private void applyNeckBankingLean(Raevyx entity, float partialTick) {
        if (!entity.m_20160_() || !entity.m_29443_()) {
            return;
        }
        float bankAngleDeg = entity.getBankAngleDegrees(partialTick);
        float neckLeanRad = -(bankAngleDeg / 45.0f) * 35.0f * ((float)Math.PI / 180);
        this.applyNeckBoneRotation("neck1Controller", neckLeanRad * 0.15f);
        this.applyNeckBoneRotation("neck2Controller", neckLeanRad * 0.2f);
        this.applyNeckBoneRotation("neck3Controller", neckLeanRad * 0.25f);
        this.applyNeckBoneRotation("neck4Controller", neckLeanRad * 0.3f);
        this.applyNeckBoneRotation("head1Controller", neckLeanRad * 0.32f);
    }

    private void applyGroundNeckTurn(Raevyx entity, float partialTick) {
        if (entity.m_29443_()) {
            return;
        }
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = Mth.m_14008_((double)velocity, (double)-25.0, (double)25.0);
        float turnRad = (float)(-velocity * 0.01745329238474369);
        this.applyNeckBoneRotation("neck1Controller", turnRad * 0.1f);
        this.applyNeckBoneRotation("neck2Controller", turnRad * 0.2f);
        this.applyNeckBoneRotation("neck3Controller", turnRad * 0.3f);
        this.applyNeckBoneRotation("neck4Controller", turnRad * 0.32f);
        this.applyNeckBoneRotation("head1Controller", turnRad * 0.35f);
    }

    private void applyNeckBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        bone.setRotY(bone.getRotY() + rotationY);
    }

    private void applyNeckFollow(Raevyx entity, EntityModelData modelData, float partialTick) {
        Optional headOpt = this.getBone("head1Controller");
        if (headOpt.isEmpty()) {
            return;
        }
        GeoBone head = (GeoBone)headOpt.get();
        double bodyDeviation = entity.bodyRotDeviation.get(partialTick);
        float lookYawRad = modelData.netHeadYaw() * ((float)Math.PI / 180);
        float structuralYawRad = (float)(bodyDeviation * 2.0 * 0.01745329238474369);
        float totalYawRad = lookYawRad + structuralYawRad;
        float lookPitchRad = modelData.headPitch() * ((float)Math.PI / 180);
        head.setRotX(head.getRotX() - lookPitchRad);
        head.setRotY(head.getRotY() - totalYawRad);
        head.setRotX(head.getInitialSnapshot().getRotX());
        head.setRotY(head.getInitialSnapshot().getRotY());
        this.applyNeckBoneFollow("neck1Controller", lookPitchRad, totalYawRad, 0.2f);
        this.applyNeckBoneFollow("neck2Controller", lookPitchRad, totalYawRad, 0.25f);
        this.applyNeckBoneFollow("neck3Controller", lookPitchRad, totalYawRad, 0.3f);
        this.applyNeckBoneFollow("neck4Controller", lookPitchRad, totalYawRad, 0.35f);
    }

    private void applyNeckBoneFollow(String boneName, float headDeltaX, float headDeltaY, float weight) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        float addX = headDeltaX * weight;
        float addY = headDeltaY * weight;
        bone.setRotX(bone.getRotX() + addX);
        bone.setRotY(bone.getRotY() + addY);
    }

    private void applyTailDrag(Raevyx entity, float partialTick) {
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = Mth.m_14008_((double)velocity, (double)-30.0, (double)30.0);
        float targetVelocity = (float)velocity;
        float smoothedVelocity = entity.smoothTailDragVelocity(targetVelocity);
        float velocityRad = smoothedVelocity * ((float)Math.PI / 180);
        this.applyTailBoneRotation("tail1", velocityRad * 0.5f);
        this.applyTailBoneRotation("tail2", velocityRad * 0.75f);
        this.applyTailBoneRotation("tail3", velocityRad * 1.0f);
        this.applyTailBoneRotation("tail4", velocityRad * 1.25f);
        this.applyTailBoneRotation("tail5", velocityRad * 1.75f);
    }

    private void applyTailBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        bone.setRotY(bone.getRotY() + rotationY);
    }
}

