/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.nulljaw;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class NulljawModel
extends DefaultedEntityGeoModel<Nulljaw> {
    private static final ResourceLocation MODEL = SaintsDragonsCommon.rl("geo/entity/nulljaw.geo.json");
    private static final ResourceLocation ANIM = SaintsDragonsCommon.rl("animations/entity/nulljaw.animation.json");
    private static final ResourceLocation MALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/nulljaw/nulljaw.png");
    private static final ResourceLocation FEMALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/nulljaw/nulljaw_female.png");

    public NulljawModel() {
        super(SaintsDragonsCommon.rl("nulljaw"));
    }

    public ResourceLocation getModelResource(Nulljaw entity) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(Nulljaw entity) {
        return entity.isFemale() ? FEMALE_TEXTURE : MALE_TEXTURE;
    }

    public ResourceLocation getAnimationResource(Nulljaw entity) {
        return ANIM;
    }

    public void setCustomAnimations(Nulljaw entity, long instanceId, AnimationState<Nulljaw> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        EntityModelData modelData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (modelData == null) {
            return;
        }
        float partialTick = animationState.getPartialTick();
        if (entity.m_6084_()) {
            if (entity.m_21224_()) {
                return;
            }
            this.applyBodyRotationDeviation(entity, partialTick);
            this.applyGroundNeckTurn(entity, partialTick);
            this.applyTailDrag(entity, partialTick);
            this.applyNeckFollow(entity, modelData, partialTick);
        }
    }

    private void applyBodyRotationDeviation(Nulljaw entity, float partialTick) {
        Optional rootOpt = this.getBone("body");
        if (rootOpt.isEmpty()) {
            return;
        }
        GeoBone root = (GeoBone)rootOpt.get();
        BoneSnapshot snap = root.getInitialSnapshot();
        double deviation = entity.bodyRotDeviation.get(partialTick);
        float deviationRad = (float)(deviation * 0.01745329238474369);
        root.setRotY(snap.getRotY() - deviationRad);
    }

    private void applyGroundNeckTurn(Nulljaw entity, float partialTick) {
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = Mth.m_14008_((double)velocity, (double)-25.0, (double)25.0);
        float turnRad = (float)(-velocity * 0.01745329238474369);
        this.applyNeckBoneRotation("neck1Controller", turnRad * 0.4f);
        this.applyNeckBoneRotation("neck2Controller", turnRad * 0.42f);
        this.applyNeckBoneRotation("neck3Controller", turnRad * 0.44f);
        this.applyNeckBoneRotation("headController", turnRad * 0.46f);
    }

    private void applyNeckBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        this.applyAdditiveRotation(bone, 0.0f, rotationY, 0.0f);
    }

    private void applyNeckFollow(Nulljaw entity, EntityModelData modelData, float partialTick) {
        Optional headOpt = this.getBone("headController");
        if (headOpt.isEmpty()) {
            return;
        }
        GeoBone head = (GeoBone)headOpt.get();
        float lookYawRad = modelData.netHeadYaw() * ((float)Math.PI / 180);
        float lookPitchRad = modelData.headPitch() * ((float)Math.PI / 180);
        double bodyDeviation = entity.bodyRotDeviation.get(partialTick);
        float structuralYawRad = (float)(bodyDeviation * 2.0 * 0.01745329238474369);
        float totalYawRad = lookYawRad + structuralYawRad;
        head.setRotX(head.getInitialSnapshot().getRotX());
        head.setRotY(head.getInitialSnapshot().getRotY());
        this.applyNeckBoneFollow("neck1Controller", lookPitchRad, totalYawRad, 0.35f);
        this.applyNeckBoneFollow("neck2Controller", lookPitchRad, totalYawRad, 0.4f);
        this.applyNeckBoneFollow("neck3Controller", lookPitchRad, totalYawRad, 0.45f);
    }

    private void applyNeckBoneFollow(String boneName, float headDeltaX, float headDeltaY, float weight) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        float addX = headDeltaX * weight;
        float addY = headDeltaY * weight;
        this.applyAdditiveRotation(bone, addX, addY, 0.0f);
    }

    private void applyTailDrag(Nulljaw entity, float partialTick) {
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = Mth.m_14008_((double)velocity, (double)-30.0, (double)30.0);
        float targetVelocity = (float)velocity;
        float smoothedVelocity = entity.smoothTailDragVelocity(targetVelocity);
        float velocityRad = smoothedVelocity * ((float)Math.PI / 180);
        this.applyTailBoneRotation("tail1", velocityRad * 1.0f);
        this.applyTailBoneRotation("tail2", velocityRad * 1.5f);
        this.applyTailBoneRotation("tail3", velocityRad * 2.0f);
        this.applyTailBoneRotation("tail4", velocityRad * 2.5f);
    }

    private void applyTailBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        this.applyAdditiveRotation(bone, 0.0f, rotationY, 0.0f);
    }

    private void applyAdditiveRotation(GeoBone bone, float addX, float addY, float addZ) {
        BoneSnapshot snap = bone.getInitialSnapshot();
        float animX = bone.getRotX() - snap.getRotX();
        float animY = bone.getRotY() - snap.getRotY();
        float animZ = bone.getRotZ() - snap.getRotZ();
        bone.setRotX(snap.getRotX() + animX + addX);
        bone.setRotY(snap.getRotY() + animY + addY);
        bone.setRotZ(snap.getRotZ() + animZ + addZ);
    }
}

