/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.ignivorus;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.ignivorus.Ignivorus;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class IgnivorusModel
extends DefaultedEntityGeoModel<Ignivorus> {
    private static final ResourceLocation MODEL = SaintsDragonsCommon.rl("geo/entity/ignivorus.geo.json");
    private static final ResourceLocation ANIM = SaintsDragonsCommon.rl("animations/entity/ignivorus.animation.json");
    private static final ResourceLocation TEXTURE = SaintsDragonsCommon.rl("textures/entity/ignivorus/ignivorus.png");
    private static final ResourceLocation FEMALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/ignivorus/ignivorus_female.png");
    private static final ResourceLocation TEXTURE_SECOND_VARIANT = SaintsDragonsCommon.rl("textures/entity/ignivorus/ignivorus_second_variant.png");
    private static final ResourceLocation FEMALE_TEXTURE_SECOND_VARIANT = SaintsDragonsCommon.rl("textures/entity/ignivorus/ignivorus_second_variant_female.png");

    public IgnivorusModel() {
        super(SaintsDragonsCommon.rl("ignivorus"));
    }

    public ResourceLocation getModelResource(Ignivorus entity) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(Ignivorus entity) {
        if (entity == null) {
            return TEXTURE;
        }
        int variant = entity.getTextureVariant();
        boolean isFemale = entity.isFemale();
        if (variant == 1) {
            return isFemale ? FEMALE_TEXTURE_SECOND_VARIANT : TEXTURE_SECOND_VARIANT;
        }
        return isFemale ? FEMALE_TEXTURE : TEXTURE;
    }

    public ResourceLocation getAnimationResource(Ignivorus entity) {
        return ANIM;
    }

    public void setCustomAnimations(Ignivorus entity, long instanceId, AnimationState<Ignivorus> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        EntityModelData modelData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (modelData == null) {
            return;
        }
        float partialTick = animationState.getPartialTick();
        if (entity.m_6084_()) {
            if (entity.isTamingStunned()) {
                return;
            }
            if (entity.m_21224_()) {
                return;
            }
            this.applyBodyRotationDeviation(entity, partialTick);
            this.applyBankingRoll(entity, animationState);
            this.applyNeckFollow(entity, modelData, partialTick);
            this.applyNeckBankingLean(entity, partialTick);
            this.applyGroundNeckTurn(entity, partialTick);
            this.applyTailDrag(entity, partialTick);
        }
    }

    private void applyBodyRotationDeviation(Ignivorus entity, float partialTick) {
        Optional rootOpt = this.getBone("body");
        if (rootOpt.isEmpty()) {
            return;
        }
        GeoBone root = (GeoBone)rootOpt.get();
        BoneSnapshot snap = root.getInitialSnapshot();
        double deviation = entity.bodyRotDeviation.get(partialTick);
        float deviationRad = (float)(deviation * 0.01745329238474369);
        root.setRotY(snap.getRotY() - deviationRad);
    }

    private void applyBankingRoll(Ignivorus entity, AnimationState<Ignivorus> state) {
        Optional bodyOpt = this.getBone("body");
        if (bodyOpt.isEmpty()) {
            return;
        }
        GeoBone body = (GeoBone)bodyOpt.get();
        BoneSnapshot snap = body.getInitialSnapshot();
        float partialTick = state.getPartialTick();
        float bankAngleDeg = entity.getBankAngleDegrees(partialTick);
        float bankAngleRad = Mth.m_14036_((float)(-bankAngleDeg * ((float)Math.PI / 180)), (float)-1.5707964f, (float)1.5707964f);
        body.setRotZ(snap.getRotZ() + bankAngleRad);
    }

    private void applyNeckBankingLean(Ignivorus entity, float partialTick) {
        if (!entity.m_20160_() || !entity.m_29443_()) {
            return;
        }
        float bankAngleDeg = entity.getBankAngleDegrees(partialTick);
        float neckLeanRad = -(bankAngleDeg / 45.0f) * 32.0f * ((float)Math.PI / 180);
        this.applyNeckBoneRotation("neck1Controller", neckLeanRad * 0.4f);
        this.applyNeckBoneRotation("neck2Controller", neckLeanRad * 0.41f);
        this.applyNeckBoneRotation("neck3Controller", neckLeanRad * 0.42f);
        this.applyNeckBoneRotation("neck4Controller", neckLeanRad * 0.43f);
        this.applyNeckBoneRotation("headController", neckLeanRad * 0.44f);
    }

    private void applyGroundNeckTurn(Ignivorus entity, float partialTick) {
        if (entity.m_29443_()) {
            return;
        }
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = Mth.m_14008_((double)velocity, (double)-25.0, (double)25.0);
        float turnRad = (float)(-velocity * 0.01745329238474369);
        this.applyNeckBoneRotation("neck1Controller", turnRad * 0.4f);
        this.applyNeckBoneRotation("neck2Controller", turnRad * 0.41f);
        this.applyNeckBoneRotation("neck3Controller", turnRad * 0.42f);
        this.applyNeckBoneRotation("neck4Controller", turnRad * 0.43f);
        this.applyNeckBoneRotation("headController", turnRad * 0.44f);
    }

    private void applyNeckBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        bone.setRotY(bone.getRotY() + rotationY);
    }

    private void applyNeckFollow(Ignivorus entity, EntityModelData modelData, float partialTick) {
        double bodyDeviation = entity.bodyRotDeviation.get(partialTick);
        float lookYawRad = modelData.netHeadYaw() * ((float)Math.PI / 180);
        float structuralYawRad = (float)(bodyDeviation * 2.0 * 0.01745329238474369);
        float totalYawRad = lookYawRad + structuralYawRad;
        float lookPitchRad = modelData.headPitch() * ((float)Math.PI / 180);
        if (entity.m_20160_()) {
            lookPitchRad = 0.0f;
        }
        this.applyNeckBoneFollow("neck1Controller", lookPitchRad, totalYawRad, 0.2f);
        this.applyNeckBoneFollow("neck2Controller", lookPitchRad, totalYawRad, 0.25f);
        this.applyNeckBoneFollow("neck3Controller", lookPitchRad, totalYawRad, 0.3f);
        this.applyNeckBoneFollow("neck4Controller", lookPitchRad, totalYawRad, 0.35f);
        this.applyNeckBoneFollow("headController", lookPitchRad, totalYawRad, 0.4f);
    }

    private void applyNeckBoneFollow(String boneName, float headDeltaX, float headDeltaY, float weight) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        float addX = headDeltaX * weight;
        float addY = headDeltaY * weight;
        bone.setRotX(bone.getRotX() + addX);
        bone.setRotY(bone.getRotY() + addY);
    }

    private void applyTailDrag(Ignivorus entity, float partialTick) {
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = Mth.m_14008_((double)velocity, (double)-30.0, (double)30.0);
        float targetVelocity = (float)velocity;
        float smoothedVelocity = entity.smoothTailDragVelocity(targetVelocity);
        float velocityRad = smoothedVelocity * ((float)Math.PI / 180);
        this.applyTailBoneRotation("tail1", velocityRad * 0.5f);
        this.applyTailBoneRotation("tail2", velocityRad * 0.75f);
        this.applyTailBoneRotation("tail3", velocityRad * 1.0f);
        this.applyTailBoneRotation("tail4", velocityRad * 1.25f);
    }

    private void applyTailBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        bone.setRotY(bone.getRotY() + rotationY);
    }
}

