/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.cindervane;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class CindervaneModel
extends DefaultedEntityGeoModel<Cindervane> {
    private static final ResourceLocation MODEL = SaintsDragonsCommon.rl("geo/entity/cindervane.geo.json");
    private static final ResourceLocation ANIM = SaintsDragonsCommon.rl("animations/entity/cindervane.animation.json");
    private static final ResourceLocation MALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/cindervane/cindervane.png");
    private static final ResourceLocation FEMALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/cindervane/cindervane_female.png");

    public CindervaneModel() {
        super(SaintsDragonsCommon.rl("cindervane"));
    }

    public void setCustomAnimations(Cindervane entity, long instanceId, AnimationState<Cindervane> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        EntityModelData modelData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (modelData == null) {
            return;
        }
        float partialTick = animationState.getPartialTick();
        if (entity.m_6084_()) {
            if (entity.m_21224_()) {
                return;
            }
            this.applyBodyRotationDeviation(entity, partialTick);
            this.applyBankingRoll(entity, animationState);
            this.applyNeckFollow(entity, modelData, partialTick);
            this.applyNeckBankingLean(entity, partialTick);
            this.applyGroundNeckTurn(entity, partialTick);
            this.applyTailDrag(entity, partialTick);
        }
    }

    public ResourceLocation getModelResource(Cindervane entity) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(Cindervane entity) {
        return entity.isFemale() ? FEMALE_TEXTURE : MALE_TEXTURE;
    }

    public ResourceLocation getAnimationResource(Cindervane entity) {
        return ANIM;
    }

    private void applyBodyRotationDeviation(Cindervane entity, float partialTick) {
        Optional rootOpt = this.getBone("body");
        if (rootOpt.isEmpty()) {
            return;
        }
        GeoBone root = (GeoBone)rootOpt.get();
        BoneSnapshot snap = root.getInitialSnapshot();
        double deviation = entity.bodyRotDeviation.get(partialTick);
        float deviationRad = (float)(deviation * 0.01745329238474369);
        root.setRotY(snap.getRotY() - deviationRad);
    }

    private void applyBankingRoll(Cindervane entity, AnimationState<Cindervane> state) {
        Optional bodyOpt = this.getBone("body");
        if (bodyOpt.isEmpty()) {
            return;
        }
        GeoBone body = (GeoBone)bodyOpt.get();
        BoneSnapshot snap = body.getInitialSnapshot();
        float partialTick = state.getPartialTick();
        float bankAngleDeg = entity.getBankAngleDegrees(partialTick);
        float bankAngleRad = Mth.m_14036_((float)(-bankAngleDeg * ((float)Math.PI / 180)), (float)-1.5707964f, (float)1.5707964f);
        body.setRotZ(snap.getRotZ() + bankAngleRad);
    }

    private void applyNeckBankingLean(Cindervane entity, float partialTick) {
        if (!entity.m_20160_() || !entity.m_29443_()) {
            return;
        }
        float bankAngleDeg = entity.getBankAngleDegrees(partialTick);
        float neckLeanRad = -(bankAngleDeg / 45.0f) * 30.0f * ((float)Math.PI / 180);
        this.applyNeckBoneRotation("neck1Controller", neckLeanRad * 0.5f);
        this.applyNeckBoneRotation("neck2Controller", neckLeanRad * 1.0f);
        this.applyNeckBoneRotation("skullController", neckLeanRad * 1.25f);
    }

    private void applyGroundNeckTurn(Cindervane entity, float partialTick) {
        if (entity.m_29443_()) {
            return;
        }
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = Mth.m_14008_((double)velocity, (double)-25.0, (double)25.0);
        float turnRad = (float)(-velocity * 0.01745329238474369);
        this.applyNeckBoneRotation("neck1Controller", turnRad * 0.5f);
        this.applyNeckBoneRotation("neck2Controller", turnRad * 1.0f);
    }

    private void applyNeckBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        bone.setRotY(bone.getRotY() + rotationY);
    }

    private void applyNeckFollow(Cindervane entity, EntityModelData modelData, float partialTick) {
        float lookYawRad = modelData.netHeadYaw() * ((float)Math.PI / 180);
        float lookPitchRad = modelData.headPitch() * ((float)Math.PI / 180);
        double bodyDeviation = entity.bodyRotDeviation.get(partialTick);
        float structuralYawRad = (float)(bodyDeviation * 2.0 * 0.01745329238474369);
        float totalYawRad = lookYawRad + structuralYawRad;
        this.applyNeckBoneFollow("neck1Controller", lookPitchRad, totalYawRad, 0.35f);
        this.applyNeckBoneFollow("neck2Controller", lookPitchRad, totalYawRad, 0.55f);
        this.applyNeckBoneFollow("skullController", lookPitchRad, totalYawRad, 0.6f);
    }

    private void applyNeckBoneFollow(String boneName, float headDeltaX, float headDeltaY, float weight) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        float addX = headDeltaX * weight;
        float addY = headDeltaY * weight;
        bone.setRotX(bone.getRotX() + addX);
        bone.setRotY(bone.getRotY() + addY);
    }

    private void applyTailDrag(Cindervane entity, float partialTick) {
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = Mth.m_14008_((double)velocity, (double)-30.0, (double)30.0);
        float targetVelocity = (float)velocity;
        float smoothedVelocity = entity.smoothTailDragVelocity(targetVelocity);
        float velocityRad = smoothedVelocity * ((float)Math.PI / 180);
        this.applyTailBoneRotation("tail1", velocityRad * 1.0f);
        this.applyTailBoneRotation("tail2", velocityRad * 2.5f);
        this.applyTailBoneRotation("tail3", velocityRad * 3.0f);
    }

    private void applyTailBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        bone.setRotY(bone.getRotY() + rotationY);
    }
}

