/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.layout;

import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.layout.Layout;
import de.johni0702.minecraft.gui.layout.LayoutData;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class HorizontalLayout
implements Layout {
    private static final Data DEFAULT_DATA = new Data(0.0);
    private final Alignment alignment;
    private int spacing;

    public HorizontalLayout() {
        this(Alignment.LEFT);
    }

    public HorizontalLayout(Alignment alignment) {
        this.alignment = alignment;
    }

    @Override
    public Map<GuiElement, Pair<ReadablePoint, ReadableDimension>> layOut(GuiContainer<?> container, ReadableDimension size) {
        int x = 0;
        int spacing = 0;
        LinkedHashMap<GuiElement, Pair<ReadablePoint, ReadableDimension>> map = new LinkedHashMap<GuiElement, Pair<ReadablePoint, ReadableDimension>>();
        for (Map.Entry<GuiElement, LayoutData> entry : container.getElements().entrySet()) {
            x += spacing;
            spacing = this.spacing;
            GuiElement element = entry.getKey();
            Data data = entry.getValue() instanceof Data ? (Data)entry.getValue() : DEFAULT_DATA;
            Dimension elementSize = new Dimension(element.getMinSize());
            ReadableDimension elementMaxSize = element.getMaxSize();
            elementSize.setWidth(Math.min(size.getWidth() - x, Math.min(elementSize.getWidth(), elementMaxSize.getWidth())));
            elementSize.setHeight(Math.min(size.getHeight(), elementMaxSize.getHeight()));
            int remainingHeight = size.getHeight() - elementSize.getHeight();
            int y = (int)(data.alignment * (double)remainingHeight);
            map.put(element, (Pair<ReadablePoint, ReadableDimension>)Pair.of((Object)new Point(x, y), (Object)elementSize));
            x += elementSize.getWidth();
        }
        if (this.alignment != Alignment.LEFT) {
            int remaining = size.getWidth() - x;
            if (this.alignment == Alignment.CENTER) {
                remaining /= 2;
            }
            for (Pair pair : map.values()) {
                ((Point)pair.getLeft()).translate(remaining, 0);
            }
        }
        return map;
    }

    @Override
    public ReadableDimension calcMinSize(GuiContainer<?> container) {
        int maxHeight = 0;
        int width = 0;
        int spacing = 0;
        for (Map.Entry<GuiElement, LayoutData> entry : container.getElements().entrySet()) {
            width += spacing;
            spacing = this.spacing;
            GuiElement element = entry.getKey();
            ReadableDimension minSize = element.getMinSize();
            int height = minSize.getHeight();
            if (height > maxHeight) {
                maxHeight = height;
            }
            width += minSize.getWidth();
        }
        return new Dimension(width, maxHeight);
    }

    public int getSpacing() {
        return this.spacing;
    }

    public HorizontalLayout setSpacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static class Data
    implements LayoutData {
        private double alignment;

        public Data() {
            this(0.0);
        }

        public Data(double alignment) {
            this.alignment = alignment;
        }

        public double getAlignment() {
            return this.alignment;
        }

        public void setAlignment(double alignment) {
            this.alignment = alignment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Data data = (Data)o;
            return Double.compare(data.alignment, this.alignment) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.alignment);
        }

        public String toString() {
            return "Data{alignment=" + this.alignment + "}";
        }
    }
}

