/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element.advanced;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.OffsetGuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractComposedGuiElement;
import de.johni0702.minecraft.gui.element.AbstractGuiElement;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.advanced.IGuiColorPicker;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.function.Draggable;
import de.johni0702.minecraft.gui.utils.Consumer;
import de.johni0702.minecraft.gui.utils.lwjgl.Color;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractGuiColorPicker<T extends AbstractGuiColorPicker<T>>
extends AbstractComposedGuiElement<T>
implements IGuiColorPicker<T>,
Clickable {
    protected static final int PICKER_SIZE = 100;
    private static final ReadableColor OUTLINE_COLOR = new Color(255, 255, 255);
    private Color color = new Color();
    private boolean opened;
    private Consumer<ReadableColor> onSelection;
    private GuiPicker picker = new GuiPicker();

    public AbstractGuiColorPicker() {
    }

    public AbstractGuiColorPicker(GuiContainer container) {
        super(container);
    }

    @Override
    public int getMaxLayer() {
        return this.opened ? 1 : 0;
    }

    @Override
    protected ReadableDimension calcMinSize() {
        return new Dimension(3, 3);
    }

    @Override
    public void layout(ReadableDimension size, RenderInfo renderInfo) {
        super.layout(size, renderInfo);
        if (size == null) {
            return;
        }
        if (renderInfo.layer == 1) {
            Dimension offsetSize = new Dimension(100, 100);
            this.picker.layout((ReadableDimension)offsetSize, renderInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        super.draw(renderer, size, renderInfo);
        if (renderInfo.layer == 0) {
            int width = size.getWidth();
            int height = size.getHeight();
            renderer.drawRect(0, 0, width, height, OUTLINE_COLOR);
            renderer.drawRect(1, 1, width - 2, height - 2, (ReadableColor)this.color);
        } else if (renderInfo.layer == 1) {
            Point offsetPoint = new Point(0, size.getHeight());
            Dimension offsetSize = new Dimension(100, 100);
            OffsetGuiRenderer offsetRenderer = new OffsetGuiRenderer(renderer, (ReadablePoint)offsetPoint, (ReadableDimension)offsetSize);
            offsetRenderer.startUsing();
            try {
                this.picker.draw(offsetRenderer, (ReadableDimension)offsetSize, renderInfo);
            }
            finally {
                offsetRenderer.stopUsing();
            }
        }
    }

    protected void getColorAtPosition(int x, int y, Color color) {
        if (x < 0 || y < 0 || x >= 100 || y >= 100) {
            throw new IndexOutOfBoundsException();
        }
        if (x < 5) {
            int intensity = 255 - y * 255 / 100;
            color.set(intensity, intensity, intensity);
        } else {
            float hue = ((float)x - 5.0f) / 95.0f;
            float saturation = Math.min((float)y / 50.0f, 1.0f);
            float brightness = Math.min(2.0f - (float)y / 50.0f, 1.0f);
            color.fromHSB(hue, saturation, brightness);
        }
    }

    @Override
    public T setColor(ReadableColor color) {
        this.color.setColor(color);
        return (T)((AbstractGuiColorPicker)this.getThis());
    }

    @Override
    public T setOpened(boolean opened) {
        this.opened = opened;
        return (T)((AbstractGuiColorPicker)this.getThis());
    }

    @Override
    public Collection<GuiElement> getChildren() {
        return this.opened ? Collections.singleton(this.picker) : Collections.emptyList();
    }

    @Override
    public T onSelection(Consumer<ReadableColor> consumer) {
        this.onSelection = consumer;
        return (T)((AbstractGuiColorPicker)this.getThis());
    }

    public void onSelection(Color oldColor) {
        if (this.onSelection != null) {
            this.onSelection.consume((ReadableColor)oldColor);
        }
    }

    @Override
    public boolean mouseClick(ReadablePoint position, int button) {
        Point pos = new Point(position);
        if (this.getContainer() != null) {
            this.getContainer().convertFor(this, pos);
        }
        if (this.isEnabled() && this.isMouseHovering((ReadablePoint)pos)) {
            this.setOpened(!this.isOpened());
            return true;
        }
        return false;
    }

    protected boolean isMouseHovering(ReadablePoint pos) {
        return pos.getX() > 0 && pos.getY() > 0 && pos.getX() < this.getLastSize().getWidth() && pos.getY() < this.getLastSize().getHeight();
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    protected class GuiPicker
    extends AbstractGuiElement<GuiPicker>
    implements Clickable,
    Draggable {
        private boolean dragging;

        protected GuiPicker() {
        }

        @Override
        protected GuiPicker getThis() {
            return this;
        }

        @Override
        public int getLayer() {
            return 1;
        }

        @Override
        protected ReadableDimension calcMinSize() {
            return new Dimension(100, 100);
        }

        @Override
        public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
            super.draw(renderer, size, renderInfo);
            Color color = new Color();
            for (int x = 0; x < 100; ++x) {
                for (int y = 0; y < 100; ++y) {
                    AbstractGuiColorPicker.this.getColorAtPosition(x, y, color);
                    renderer.drawRect(x, y, 1, 1, (ReadableColor)color);
                }
            }
        }

        @Override
        public boolean mouseClick(ReadablePoint position, int button) {
            if (this.isEnabled()) {
                Point pos = new Point(position);
                AbstractGuiColorPicker parent = AbstractGuiColorPicker.this;
                if (parent.getContainer() != null) {
                    parent.getContainer().convertFor(parent, pos, 1);
                }
                pos.translate(0, -AbstractGuiColorPicker.this.getLastSize().getHeight());
                if (this.isMouseHovering((ReadablePoint)pos)) {
                    Color oldColor = new Color((ReadableColor)AbstractGuiColorPicker.this.color);
                    AbstractGuiColorPicker.this.getColorAtPosition(pos.getX(), pos.getY(), AbstractGuiColorPicker.this.color);
                    this.dragging = true;
                    AbstractGuiColorPicker.this.onSelection(oldColor);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean mouseDrag(ReadablePoint position, int button, long timeSinceLastCall) {
            return this.dragging && this.mouseClick(position, button);
        }

        @Override
        public boolean mouseRelease(ReadablePoint position, int button) {
            if (this.dragging) {
                this.dragging = false;
                return true;
            }
            return false;
        }

        protected boolean isMouseHovering(ReadablePoint pos) {
            return pos.getX() > 0 && pos.getY() > 0 && pos.getX() < 100 && pos.getY() < 100;
        }
    }
}

