/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element;

import de.johni0702.minecraft.gui.element.GuiElement;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ComposedGuiElement<T extends ComposedGuiElement<T>>
extends GuiElement<T> {
    public Collection<GuiElement> getChildren();

    default public <C, R> R forEach(Class<C> ofType, Function<C, R> function) {
        return (R)this.forEach((elem, elemLayer) -> elem.forEach((int)elemLayer, ofType, function));
    }

    default public <C, R> R forEach(BiFunction<ComposedGuiElement<?>, Integer, R> recurse) {
        int maxLayer;
        for (int i = maxLayer = this.getMaxLayer(); i >= 0; --i) {
            R result = recurse.apply(this, i);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    default public <C, R> R forEach(int layer, Class<C> ofType, Function<C, R> function) {
        return (R)this.forEach(layer, ofType, (elem, elemLayer) -> elem.forEach((int)elemLayer, ofType, function), function);
    }

    public <C, R> R forEach(int var1, Class<C> var2, BiFunction<ComposedGuiElement<?>, Integer, R> var3, Function<C, R> var4);

    default public <C> void invokeAll(Class<C> ofType, Consumer<C> consumer) {
        this.forEach((elem, elemLayer) -> {
            elem.invokeAll((int)elemLayer, ofType, consumer);
            return null;
        });
    }

    default public <C> void invokeAll(int layer, Class<C> ofType, Consumer<C> consumer) {
        this.forEach(layer, ofType, (elem, elemLayer) -> {
            elem.invokeAll((int)elemLayer, ofType, consumer);
            return null;
        }, obj -> {
            consumer.accept(obj);
            return null;
        });
    }

    default public <C> boolean invokeHandlers(Class<C> ofType, Function<C, Boolean> handle) {
        return this.forEach((elem, elemLayer) -> elem.invokeHandlers((int)elemLayer, ofType, handle) ? Boolean.valueOf(true) : null) == Boolean.TRUE;
    }

    default public <C> boolean invokeHandlers(int layer, Class<C> ofType, Function<C, Boolean> handle) {
        return this.forEach(layer, ofType, (elem, elemLayer) -> elem.invokeHandlers((int)elemLayer, ofType, handle) ? Boolean.valueOf(true) : null, obj -> (Boolean)handle.apply(obj) != false ? Boolean.valueOf(true) : null) == Boolean.TRUE;
    }

    public int getMaxLayer();
}

