/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiButton;
import de.johni0702.minecraft.gui.element.IGuiToggleButton;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;

public abstract class AbstractGuiToggleButton<V, T extends AbstractGuiToggleButton<V, T>>
extends AbstractGuiButton<T>
implements IGuiToggleButton<V, T> {
    private int selected;
    private V[] values;

    public AbstractGuiToggleButton() {
    }

    public AbstractGuiToggleButton(GuiContainer container) {
        super(container);
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        String orgLabel = this.getLabel();
        this.setLabel(orgLabel + ": " + this.values[this.selected]);
        super.draw(renderer, size, renderInfo);
        this.setLabel(orgLabel);
    }

    @Override
    public void onClick() {
        this.selected = (this.selected + 1) % this.values.length;
        super.onClick();
    }

    @Override
    public T setValues(V ... values) {
        this.values = values;
        return (T)((AbstractGuiToggleButton)this.getThis());
    }

    @Override
    public T setSelected(int selected) {
        this.selected = selected;
        return (T)((AbstractGuiToggleButton)this.getThis());
    }

    @Override
    public V getSelectedValue() {
        return this.values[this.selected];
    }

    @Override
    public int getSelected() {
        return this.selected;
    }

    @Override
    public V[] getValues() {
        return this.values;
    }
}

