/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiButton;
import de.johni0702.minecraft.gui.element.AbstractGuiClickable;
import de.johni0702.minecraft.gui.element.IGuiCheckbox;
import de.johni0702.minecraft.gui.utils.lwjgl.Color;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.versions.MCVer;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractGuiCheckbox<T extends AbstractGuiCheckbox<T>>
extends AbstractGuiClickable<T>
implements IGuiCheckbox<T> {
    protected static final ResourceLocation BUTTON_SOUND = new ResourceLocation("gui.button.press");
    protected static final ReadableColor BOX_BACKGROUND_COLOR = new Color(46, 46, 46);
    private String label;
    private boolean checked;

    public AbstractGuiCheckbox() {
    }

    public AbstractGuiCheckbox(GuiContainer container) {
        super(container);
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        super.draw(renderer, size, renderInfo);
        int color = 0xE0E0E0;
        if (!this.isEnabled()) {
            color = 0xA0A0A0;
        }
        int boxSize = size.getHeight();
        renderer.drawRect(0, 0, boxSize, boxSize, ReadableColor.BLACK);
        renderer.drawRect(1, 1, boxSize - 2, boxSize - 2, BOX_BACKGROUND_COLOR);
        if (this.isChecked()) {
            renderer.drawCenteredString(boxSize / 2 + 1, 1, color, "x", true);
        }
        renderer.drawString(boxSize + 2, 2, color, this.label);
    }

    @Override
    public ReadableDimension calcMinSize() {
        Font fontRenderer = MCVer.getFontRenderer();
        Objects.requireNonNull(fontRenderer);
        int height = 9 + 2;
        int width = height + 2 + fontRenderer.m_92895_(this.label);
        return new Dimension(width, height);
    }

    @Override
    public ReadableDimension getMaxSize() {
        return this.getMinSize();
    }

    @Override
    public void onClick() {
        AbstractGuiButton.playClickSound(this.getMinecraft());
        this.setChecked(!this.isChecked());
        super.onClick();
    }

    @Override
    public T setLabel(String label) {
        this.label = label;
        return (T)((AbstractGuiCheckbox)this.getThis());
    }

    @Override
    public T setI18nLabel(String label, Object ... args) {
        return (T)this.setLabel(I18n.m_118938_((String)label, (Object[])args));
    }

    @Override
    public T setChecked(boolean checked) {
        this.checked = checked;
        return (T)((AbstractGuiCheckbox)this.getThis());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isChecked() {
        return this.checked;
    }
}

